package bumblebee;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Random;

import robocode.AdvancedRobot;
import robocode.DeathEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import net.sf.robocode.io.Logger;
import static java.lang.Math.*;

public class Bumblebee extends AdvancedRobot {
	private boolean aimed = false;
	double oldEnemyHeading = 0;
	double oldEnemyHealth = 100;
	private int direction = 1;
	public void run() {
		while (true) {

		    do {
		        setTurnRight(PI/2);
		    	turnRadarRightRadians(Double.POSITIVE_INFINITY);
		        ahead(100 * direction);
		        
		    } while (true);
		}

	}

	public void onScannedRobot(ScannedRobotEvent e) {
		
		double bulletPower = Math.min(3.0,getEnergy());
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyHeadingChange = enemyHeading - oldEnemyHeading;
		double enemyVelocity = e.getVelocity();
		oldEnemyHeading = enemyHeading;
		if(oldEnemyHealth > e.getEnergy()){
			setAhead(100 * direction);
		}
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), 
		       battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX;
		double predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < 
			      Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
				predictedX += Math.sin(enemyHeading) * enemyVelocity;
				predictedY += Math.cos(enemyHeading) * enemyVelocity;
				enemyHeading += enemyHeadingChange;
				if(	predictedX < 18.0 
					|| predictedY < 18.0
					|| predictedX > battleFieldWidth - 18.0
					|| predictedY > battleFieldHeight - 18.0){
			 
					predictedX = Math.min(Math.max(18.0, predictedX), 
					    battleFieldWidth - 18.0);	
					predictedY = Math.min(Math.max(18.0, predictedY), 
					    battleFieldHeight - 18.0);
					break;
				}
			}
			double theta = Utils.normalAbsoluteAngle(Math.atan2(
			    predictedX - getX(), predictedY - getY()));
			 
			setTurnRadarRightRadians(Utils.normalRelativeAngle(
			    absoluteBearing - getRadarHeadingRadians()));
			setTurnGunRightRadians(Utils.normalRelativeAngle(
			    theta - getGunHeadingRadians()));
			fire(3);
			setTurnRight(PI/2);
			setTurnRadarLeftRadians(Double.POSITIVE_INFINITY);
					
		
		
		
	}
	@Override
	public void onHitWall(HitWallEvent event) {
		direction *=-1;
	}
}
