package axeBots.pilot.navigator;
import axeBots.AxeBot;
import axeBots.SilverSurfer;
import axeBots.data.SegmentedGFs;
import axeBots.silversurfer.AxeTarget;
import axeBots.pilot.AxePilot;
import axeBots.pilot.waves.EnemyWave;
/**
 * @author Marcos Machado
 * @since 19/02/2004 @modified
 */
public class WaveNavigator {
	private int desiredGF;
	private long timeToStop;
	protected SilverSurfer me = null;
	protected AxeTarget enemy = null;
	protected static EnemyWave wave = null;
	protected SegmentedGFs gfHolder = null;
	protected boolean dangerPts[] = new boolean[SegmentedGFs.GF_QT];
	private AxePilot pilot = null;
	private int travelDistance = 0;
	private static boolean recalculate = false;
	/**
	 * @author Marcos Machado
	 * @since 19/02/2004 @modified
	 */
	public WaveNavigator(AxePilot pilot) {
		super();
		me = AxeBot.getIt();
		this.pilot = pilot;
		Course.setLastChangeTime(0);
	}

	private boolean navigate(boolean newWave) {
		boolean ret = true;
		if (wave != null) {
			if (newWave || recalculate) {
				ret = Course.traceCourse(this);

			} else {
				//                Course.process();
				if (Course.getCourse().timeToWall == 0) {
					this.setTravelDistance(0);
				}
			}
			if (Course.getCourse() != null) {
				desiredGF = (int) Course.chosen;
				if (me.isRe() ^ Course.getCourse().re) {
					pilot.invert();
				}
			}
		}
		setRecalculate( false);
		return ret;
	}

	public AxeTarget getEnemy() {
		return enemy;
	}
	/**
	 * @return @author Marcos Machado
	 * @since 19/02/2004 @modified
	 */

	public SegmentedGFs getGfHolder() {
		return gfHolder;
	}
	public static EnemyWave getWave() {
		return wave;
	}
	private void setEnemy(AxeTarget target) {
		enemy = target;
		gfHolder = (target == null) ? null : enemy.getBotData().getGfHistory();
	}
	public void setWave(EnemyWave wave) {
		
		if (WaveNavigator.wave != wave) {
			this.setEnemy((wave == null) ? null : wave.getOwner());
			
			EnemyWave.estimateArrivalDeltas(); 
			WaveNavigator.wave = wave;
			if(!navigate(true)){
				WaveNavigator.wave=null;
			}
			
		} else {
			navigate(false);
			if ((wave != null) && wave.isDangerZone()) {
			}
		}
	}
	/**
	 * @return
	 */
	public boolean[] getDangerPoints() {
		return dangerPts;
	}
	/**
	 * @return
	 */
	public long getTimeToStop() {
		long ret = timeToStop;

		return ret;
	}
	/**
	 *  
	 */
	public int getAimedGF() {
		return desiredGF;
	}
	/**
	 * @return
	 */
	public int getTravelDistance() {
		return travelDistance;
	}
	/**
	 * @param i
	 */
	public void setTravelDistance(int i) {
		travelDistance = i;
	}
	public static void setRecalculate(boolean r) {
		recalculate = r;
	}
}