/*
 * Created on Oct 25, 2004
 *
 */
package davidalves.net.gun.segmentation;

import davidalves.net.util.RobotState;

/**
 * @author David Alves
 *
 */
public class NonlinearDistanceSegmentation extends Segmentation {

	/* (non-Javadoc)
	 * @see davidalves.net.gun.Segmentation#numSegments()
	 */
	public int numSegments() {
		
		return 5;
	}

	/* (non-Javadoc)
	 * @see davidalves.net.gun.Segmentation#getSegment(davidalves.net.util.RobotState, davidalves.net.util.RobotState, double)
	 */
	public int getSegment(RobotState shooter, RobotState target,
			double bulletPower) {
		double distance = shooter.distanceTo(target);
		if(distance > 950) return 4; //Max distance on 800x600 field = 949.6273
		if(distance > 500) return 3;
		if(distance > 300) return 2;
		if(distance > 150) return 1;
		/* distance < 150*/return 0;
		
	}

	public static void main(String[] args) {
	}
}
