package lancel.components;
import robocode.util.Utils;
import java.awt.geom.Point2D;
import static java.lang.Math.*;

/**************************************************************************************************
 Lynx - A duelist, based on Dynamic Clustering (DC) and WaveSurfing
 Author: lancel
 Current Version: 1.09
 Date: 6/12/2010
 License: Open Source under the RoboWiki Public Code License RWPCL (http://robowiki.net/wiki/RWPCL)
 Robocode Version: 1.6.1.4 (because of RoboRumble)
 Techniques this bot is based on:
    Gun: a k-nearest neighbors search with a kd-tree using a simple kernel density estimation 
         (dynamic clustering)
    Movement: basic WaveSurfing using the closest wave as a surfing wave
 CREDITS: Much of the ideas and code is based on various sources. A few to mention:
    wiki.BasicGFSurfer by Voidius, Pez and Bayen: initial structure for Lynx and the implementation
        of WaveSurfing
    Komarious by Voidius: the segmentation for WaveSurfing
    ABC: inventor of WaveSurfing
    Rednaxela: the implementation of the kd-tree
    rozu: precise prediction used in the Lynx's movement system
    DrussGT by Skilgannon: normalizing and weighting "features" that describe states for the gun
        ("segmentation" in DC) 
    Raiko by Jamougha: choosing a bullet power
    PEZ: Simple Iterative Wall Smoothing
    Voidious and others: good tutorials for getting into robocoding
**************************************************************************************************/

public class MyUtils {
//-------------------------------------------------------------------------------------------------
// Some commonly used utility functions that are collected from various bots.

    public static Point2D.Double project(Point2D.Double sourceLocation,
        double angle, double length) {
    //---------------------------------------------------------------------------------------------
        return new Point2D.Double(sourceLocation.x + sin(angle) * length,
            sourceLocation.y + cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
    //---------------------------------------------------------------------------------------------
        return atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
    //---------------------------------------------------------------------------------------------
        return max(min, min(value, max));
    }

    public static double maxEscapeAngle(double velocity) {
    //---------------------------------------------------------------------------------------------
        return asin(8.0 / velocity);
    }

    public static int getFactorIndex(Movement.OppWave ow, Point2D.Double myLocation, int bins) {
    //---------------------------------------------------------------------------------------------
        return (int)MyUtils.limit(0, ((((Utils.normalRelativeAngle(ow.absoluteBearing(myLocation)
            - ow.directAngle) * ow.direction) / asin(8.0/ow.bulletVelocity))* (bins-1)/2) +
            (bins-1)/2), bins - 1);
    }
} // end class MyUtils
