package lucasslf.development;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import lucasslf.LucasslfBot;
import lucasslf.utility.FastTrig;
import lucasslf.utility.ScannedRobot;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;




//TODO: Buffer Classes with weights
public class Gun2 {

	private static int SEG_HEADING_DIFFERENCE = 19;
	private static int SEG_DISTANCE = 13;
	private static int SEG_VELOCITY = 9;
	private static int SEG_MOVE = 10;
	private static int SEG_BULLET_POWER = 4;
	private static int SEG_WALL_PROXIMITY = 3;
	public static int BINS = 51;
	
	//Just to keep track of the waves we fired
	private static int WAVE_IDS=0;
	
	//Stats
	public static double[][][][][][][] statsA = new double[SEG_WALL_PROXIMITY][SEG_BULLET_POWER][SEG_HEADING_DIFFERENCE][SEG_VELOCITY][SEG_VELOCITY][SEG_DISTANCE][BINS];
	public static double[][][][][] statsB = new double[SEG_WALL_PROXIMITY][SEG_BULLET_POWER][SEG_VELOCITY][SEG_DISTANCE][BINS];
	public static double[][][][] statsC = new double[SEG_BULLET_POWER][SEG_HEADING_DIFFERENCE][SEG_DISTANCE][BINS];
	public static double[][][][] statsD = new double[SEG_VELOCITY][SEG_HEADING_DIFFERENCE][SEG_DISTANCE][BINS];
	public static double[][][][][] statsE = new double[SEG_MOVE][SEG_VELOCITY][SEG_VELOCITY][SEG_DISTANCE][BINS];
	public static double[][][][][] statsF = new double[SEG_MOVE][SEG_BULLET_POWER][SEG_VELOCITY][SEG_DISTANCE][BINS];
	
	//For rolling avgs
	private static int readings;
	
	//Waves
	private List<Wave> waves = new ArrayList<Wave>();
	
	//Last status of the enemy
	private ScannedRobot lastScannedRobot = new ScannedRobot();
	//Current location of the enemy
	//after onScannedRobot it's equals to lastScannedRobot.position
	//maybe it's useless
	private static Point2D targetPosition;

	
	private int moveTimes = 0;
	
	//The robot using the gun
	LucasslfBot r;

	public Gun2(LucasslfBot r) {
		super();
		this.r = r;
	}

	public void onBulletMissed(BulletMissedEvent e) {
		r.bullets.remove(e.getBullet());
		for (int i = 0; i < waves.size(); i++) {
			Wave wave = waves.get(i);
			if (wave.checkBulletMiss(e.getBullet())) {
				waves.remove(wave);
				r.removeCustomEvent(wave);
				return;
			}
		}		
		
		
	}

	public void onBulletHitBullet(BulletHitBulletEvent e) {
		r.bullets.remove(e.getBullet());
	}

	public void onBulletHit(BulletHitEvent e) {
		checkWavesForBullet(e.getBullet());
		r.bullets.remove(e.getBullet());
	}

	public void onHitByBullet(HitByBulletEvent e) {

	}

	public void onHitRobot(HitRobotEvent e) {

	}

	public void onPaint(Graphics2D g) {
		for (Wave wave : waves) {
			wave.draw(g);
		}
	}
	

	//0 - Próximo ao muro
	//1 - Corner
	//2 - Meio
	private int getWallSegmentFrom(Point2D position){
		int retorno = 2 ;
		double x = position.getX();
		double y = position.getY();
		boolean nearVerticalWalls = (x< 50 || (r.getBattleFieldWidth() - x < 50));
		boolean nearHorizontalWalls = (y< 50 || (r.getBattleFieldHeight() - y < 50));
		
		if(nearHorizontalWalls && nearVerticalWalls){
			return 1;
		}
		if(nearVerticalWalls || nearHorizontalWalls)
			return 0;
		
		
		return retorno;
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		double enemyAbsoluteBearing = r.getHeadingRadians()
				+ e.getBearingRadians();
		double headingDifference = e.getHeading() - r.getHeading();
		
		double lateralVelocity = e.getVelocity()
		* FastTrig.sin(e.getBearingRadians() - FastTrig.PI);
		int enemyDirection = 0;
			if (FastTrig.sin(e.getHeadingRadians() - enemyAbsoluteBearing)
					* e.getVelocity() < 0)
				enemyDirection = -1;
			else
				enemyDirection = 1;
		
		if (e.getVelocity() == 0)
			moveTimes = 0;
		else
			moveTimes++;
		
		
		//Power calculation from somewhere I don't remember now
		boolean rammer =  e.getDistance() < 200;
		double power = rammer ? 3 : Math.min(1.9,	Math.min(r.getEnergy() / 16.0, e.getEnergy() / 2.0));
		
		double ex = r.getX() + FastTrig.sin(enemyAbsoluteBearing) * e.getDistance();
		double ey = r.getY() + FastTrig.cos(enemyAbsoluteBearing) * e.getDistance();
		targetPosition = new Point2D.Double(ex, ey);
		
		
		
		int segHeadingDifferenceIndex = (int) (headingDifference + 360) / 40;
		int segDistanceIndex = (int) e.getDistance() / 100;
		int segBulletPowerIndex = (int) power;
		int segLastEnemyVelocityIndex = (int) (lastScannedRobot.velocity/2 + (SEG_VELOCITY-1)/2);
		int segLateralVelocity = (int) (lateralVelocity/2 + (SEG_VELOCITY-1)/2);
		int segEnemyVelocityIndex = (int) (e.getVelocity()/2 + (SEG_VELOCITY-1)/2);
		int segWallProximityIndex = getWallSegmentFrom(targetPosition);
		int segMoveTimesIndex = Math.min(9, moveTimes / 5);
		int bestIndex = (BINS - 1) / 2;

		
		
		double[] auxA = statsA[segWallProximityIndex][segBulletPowerIndex][segHeadingDifferenceIndex][segLastEnemyVelocityIndex][segEnemyVelocityIndex][segDistanceIndex];
		double[] auxB = statsB[segWallProximityIndex][segBulletPowerIndex][segLateralVelocity][segDistanceIndex];
		double[] auxC = statsC[segBulletPowerIndex][segHeadingDifferenceIndex][segDistanceIndex];
		double[] auxD = statsD[segEnemyVelocityIndex][segHeadingDifferenceIndex][segDistanceIndex];
		double[] auxE = statsE[segMoveTimesIndex][segLastEnemyVelocityIndex][segEnemyVelocityIndex][segDistanceIndex];
		double[] auxF = statsF[segMoveTimesIndex][segBulletPowerIndex][segLateralVelocity][segDistanceIndex];
		
		
		// Finds the most visited bin
		double[][] buffers = {auxA,auxB,auxC,auxD,auxE,auxF};
		//double[][] buffers = {auxE,auxF};
		double[] weights = {1,1,1,1,1,1};
		double bestBinScore = 0;
		for (int i = 0; i < BINS; i++) {
			double binScore = 0;
			int w=0;
			for(double[] buffer : buffers){
				binScore+=buffer[i]*weights[w];
				w++;
			}
			if (bestBinScore < binScore) {
				bestIndex= i;
				bestBinScore = binScore;
			}
		}
		
		/*
		for(double[] buffer : buffers){
			for (int i = 0; i < buffer.length; i++) {
				if (bestBinScore <= buffer[i]) {
					bestIndex= i;
					bestBinScore = buffer[i];
				}
			}	
		}
		
		 */
		//Calculate weighted avg between the most visited bin and its neighbors
		/*
		double avgIndex = 0;
		double weightCount = 0;
		if(auxA[bestIndexA]!=0){
			for(int i = Math.max(0, bestIndexA-2);i< Math.min(bestIndexA+2,BINS);i++){
				weightCount += auxA[i];
				avgIndex += i*auxA[i];
			}
			avgIndex = avgIndex/weightCount;
		}else{
			 avgIndex = bestIndexA;
		}
		*/
		Wave wave = new Wave(
				new Point2D.Double(r.getX(), r.getY()), enemyAbsoluteBearing,
				power, enemyDirection, (int)bestIndex,auxA,auxB,auxC,auxD,auxE,auxF);
		
		double fator = (2 * (double) bestIndex / ((double) BINS - 1)) - 1;
		double angleOffset = enemyDirection * fator * wave.getMaxEscapeAngle();
		double gunAdjust = Utils.normalRelativeAngle(enemyAbsoluteBearing
				- r.getGunHeadingRadians() + angleOffset+0.005);

		
		r.setTurnGunRightRadians(gunAdjust);
		if (r.getGunHeat() == 0) {
			Bullet b = r.setFireBullet(power);
			System.out.println(bestIndex+" "+fator);
			wave.setBullet(b);
			r.bullets.add(b);
		}
		waves.add(wave);
		r.addCustomEvent(wave);

		
		lastScannedRobot = new ScannedRobot();
		lastScannedRobot.energy = e.getEnergy();
		lastScannedRobot.name = e.getName();
		lastScannedRobot.bearing = enemyAbsoluteBearing;
		lastScannedRobot.time = e.getTime();
		lastScannedRobot.velocity = e.getVelocity();
		lastScannedRobot.position = targetPosition;
		
	}
	
	private void checkWavesForBullet(Bullet b) {
		for (int i = 0; i < waves.size(); i++) {
			Wave wave = waves.get(i);
			if (wave.checkBullet(b)) {
				waves.remove(wave);
				r.removeCustomEvent(wave);
				return;
			}
		}
	}

	
	
	class Wave extends Condition {

		
		private int id=WAVE_IDS++;
		private double bulletPower;
		private double distanceTraveled;
		private double[] bufferA;
		private double[] bufferB;
		private double[] bufferC;
		private double[] bufferD;
		private double[] bufferE;
		private double[] bufferF;
		private double initialAngle;
		private Bullet bullet;
		private Point2D initialPosition;
		private int enemyDirection;
		private int usedIndex;

				
		public Wave(Point2D initialPosition, double initialAngle,double bulletPower, int enemyDirection,
				  int usedIndex,
					double[] bufferA,
					double[] bufferB,
					double[] bufferC,
					double[] bufferD,
					double[] bufferE,
					double[] bufferF) {
			super();
			this.initialPosition = initialPosition;
			this.initialAngle = initialAngle;
			this.bulletPower = bulletPower;
			this.enemyDirection = enemyDirection;
			this.usedIndex = usedIndex;
			this.bufferA = bufferA;
			this.bufferB = bufferB;
			this.bufferC = bufferC;
			this.bufferD = bufferD;
			this.bufferE = bufferE;
			this.bufferF = bufferF;
		}

		

		public int getUsedIndex() {
			return usedIndex;
		}
		
		public void setBullet(Bullet bullet) {
			this.bullet = bullet;
		}



		public double getBulletSpeed() {
			return 20.0 - (bulletPower * 3.0);
		}

		private void updateTravel() {
			distanceTraveled += this.getBulletSpeed();
		}

		public boolean checkHit(Point2D enemyPosition) {

			if ( initialPosition.distance(enemyPosition) <= distanceTraveled) {
				double desiredDirection = FastTrig.atan2(enemyPosition.getX()
						- initialPosition.getX(), enemyPosition.getY()
						- initialPosition.getY());
				double angleOffset = Utils.normalRelativeAngle(desiredDirection
						- initialAngle);
				System.out.println(enemyDirection+" "+angleOffset+" "+getMaxEscapeAngle()+" "+angleOffset / getMaxEscapeAngle());
				double guessFactor = Math.max(-1,
						Math.min(1, angleOffset / getMaxEscapeAngle()))* enemyDirection;
				int index = (int) Math.round((BINS - 1) / 2
						* (guessFactor + 1));

				System.out.println("hit: "+guessFactor+" "+index);
				
				for (int i = 0; i < bufferA.length; i++){
						double value = (1.0 + (bullet==null?0:1)) / (Math.pow(index - i, 2.0) + 1.0);
						bufferA[i] = lucasslf.utility.Utils.rollingAvg(	bufferA[i], value, Math.min(readings++, 200), 3);
						bufferB[i] = lucasslf.utility.Utils.rollingAvg(	bufferB[i], value, Math.min(readings++, 200), 3);
						bufferC[i] = lucasslf.utility.Utils.rollingAvg(	bufferC[i], value, Math.min(readings++, 200), 3);
						bufferD[i] = lucasslf.utility.Utils.rollingAvg(	bufferD[i], value, Math.min(readings++, 200), 3);
						bufferE[i] = lucasslf.utility.Utils.rollingAvg(	bufferE[i], value, Math.min(readings++, 200), 3);
						bufferF[i] = lucasslf.utility.Utils.rollingAvg(	bufferF[i], value, Math.min(readings++, 200), 3);
				}
				return true;
			}
			return false;
		}

		public boolean checkBullet(Bullet b) {
			if (bullet != null && bullet.equals(b)) {
				

				for (int i = 0; i < bufferA.length; i++){
						double value = 2.0 / (Math.pow(usedIndex - i, 2.0) + 1.0);
						bufferA[i] = lucasslf.utility.Utils.rollingAvg(	bufferA[i], value, Math.min(readings++, 200), 3);
						bufferB[i] = lucasslf.utility.Utils.rollingAvg(	bufferB[i], value, Math.min(readings++, 200), 3);
						bufferC[i] = lucasslf.utility.Utils.rollingAvg(	bufferC[i], value, Math.min(readings++, 200), 3);
						bufferD[i] = lucasslf.utility.Utils.rollingAvg(	bufferD[i], value, Math.min(readings++, 200), 3);
						bufferE[i] = lucasslf.utility.Utils.rollingAvg(	bufferE[i], value, Math.min(readings++, 200), 3);
						bufferF[i] = lucasslf.utility.Utils.rollingAvg(	bufferF[i], value, Math.min(readings++, 200), 3);
				}
				return true;
			}
			return false;
		}

		
	    public int getId() {
			return id;
		}
		public double getMaxEscapeAngle() {
			return Math.asin(8 / getBulletSpeed());
		}

		public boolean checkBulletMiss(Bullet b) {
			if (bullet != null && bullet.equals(b)) {
				for (int i = 0; i < bufferA.length; i++){
						double value = i==usedIndex?  -0.5 / (Math.pow(usedIndex - i, 2.0) + 1.0):0;
						bufferA[i] = lucasslf.utility.Utils.rollingAvg(	bufferA[i],value, Math.min(readings++, 200), 3);
						bufferB[i] = lucasslf.utility.Utils.rollingAvg(	bufferB[i], value, Math.min(readings++, 200), 3);
						bufferC[i] = lucasslf.utility.Utils.rollingAvg(	bufferC[i], value, Math.min(readings++, 200), 3);
						bufferD[i] = lucasslf.utility.Utils.rollingAvg(	bufferD[i], value, Math.min(readings++, 200), 3);
						bufferE[i] = lucasslf.utility.Utils.rollingAvg(	bufferE[i], value, Math.min(readings++, 200), 3);
						bufferF[i] = lucasslf.utility.Utils.rollingAvg(	bufferE[i], value, Math.min(readings++, 200), 3);
				}
				return true;
			}
			return false;
		}

		@Override
		public boolean test() {

			
			if(checkHit(targetPosition)){
				r.removeCustomEvent(this);
				waves.remove(this);
				return false;
			}
			updateTravel();
			return false;
		}
		public double getMinFactorFromBuffer() {
			double aux = Double.POSITIVE_INFINITY;
			for (double f : bufferA) {
				if (f < aux)
					aux = f;
			}
			return aux;
		}
		
		public double getMaxFactorFromBuffer() {
			double aux = Double.NEGATIVE_INFINITY;
			for (double f : bufferA) {
				if (f > aux)
					aux = f;
			}
			return aux;
		}

		public void draw(Graphics2D g) {
			// Draw wave
			double raio = this.distanceTraveled;
			double lado = raio * 2;
			double x = (initialPosition.getX() - raio);
			double y = (initialPosition.getY() - raio);
			double initialArcAngleDegrees = lucasslf.utility.Utils.toDegrees(initialAngle
					- getMaxEscapeAngle()) - 90;
			double arcAngleDegrees = lucasslf.utility.Utils.toDegrees(getMaxEscapeAngle() * 2 / BINS);

			double maxFactor = getMaxFactorFromBuffer();
			double minFactor = getMinFactorFromBuffer();
			for (int i = 0; i < BINS; i++) {
				int colorSbtFactor = (int) ((bufferA[i] - minFactor)/ (maxFactor-minFactor) * 255);
				g.setColor(new Color(255, 255 - colorSbtFactor,
						255 - colorSbtFactor));
				Arc2D arc = new Arc2D.Double(x, y, lado, lado,
						initialArcAngleDegrees, arcAngleDegrees, Arc2D.OPEN);
				g.draw(arc);
				initialArcAngleDegrees += arcAngleDegrees;
			}

		}


	}

}
