package ags.utils.dataStructures.trees.thirdGenKD;

/**
 *
 */
public class WeightedManhattanDistanceFunction extends WeightedDistanceFunction implements DistanceFunction {
	
	// Constructor. Loads weights.
	public WeightedManhattanDistanceFunction(double[] weights) {
		super(weights);
	}
	
	// Unweighted constructor, just in case the user forgets to specify weights.
	// In this failover case, this DistanceFunction should give identical results as ManhattanDistanceFunction
	public WeightedManhattanDistanceFunction() {
		super();
	}

    @Override
    public double distance(double[] p1, double[] p2) {
        double d = 0;

        for (int i = 0; i < p1.length; i++) {
            double diff = Math.abs(getWeight(i)*(p1[i] - p2[i]));
            d += diff;
        }

        return d;
    }

    @Override
    public double distanceToRect(double[] point, double[] min, double[] max) {
        double d = 0;

        for (int i = 0; i < point.length; i++) {
            double diff = 0;
            if (point[i] > max[i]) {
                diff = Math.abs(getWeight(i)*(point[i] - max[i]));
            }
            else if (point[i] < min[i]) {
                diff = Math.abs(getWeight(i)*(point[i] - min[i]));
            }
            d += diff;
        }

        return d;
    }
}