package suh.util;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.util.Utils;

public class Utility {
    public static int sign(double n) {
	return n < 0 ? -1 : 1;
    }
    
    public static Point2D.Double project(Point2D.Double source, double angle, double length) {
	return new Point2D.Double(source.x + length * Math.sin(angle), source.y + length * Math.cos(angle));
    }
    
    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }
    
    public static double maxEscapeAngle(double velocity) {
	return Math.asin(8.0 / velocity);
    }
    
    public static double limit(double min, double value, double max) {
	return Math.max(min, Math.min(value, max));
    }
    
    public static double bulletVelocity(double power) {
	return Rules.getBulletSpeed(power);
    }
    
    public static void goTo(AdvancedRobot self, double x, double y) {
	setMove(self, Utils.normalRelativeAngle(Math.atan2(x = x - self.getX(), y = y - self.getY()) - self.getHeadingRadians()), Math.hypot(x, y));
    }
    
    public static void setMove(AdvancedRobot self, double angle, double distance) {
	double turnAngle;
	self.setTurnRightRadians(turnAngle = Math.atan(Math.tan(angle)));
	self.setAhead((angle == turnAngle) ? distance : -distance);
    }
    
    public static void setBackAsFront(AdvancedRobot self, double goAngle) {
	double angle = Utils.normalRelativeAngle(goAngle - self.getHeadingRadians());
        if(Math.abs(angle) > (Math.PI/2)) {
	    if (angle < 0) {
                self.setTurnRightRadians(Math.PI + angle);
            } else {
                self.setTurnLeftRadians(Math.PI - angle);
            }
            self.setBack(100);
        } else {
           if(angle < 0) {
                self.setTurnLeftRadians(-1*angle);
           } else {
                self.setTurnRightRadians(angle);
           }
           self.setAhead(100);
        }
    }
}
