package tzu.movement;

import tzu.util.*;
import tzu.intel.*;
import tzu.strategy.*;
import robocode.*;

/**
 * Provides one useful method, calcAntiGravity, which
 * calls the respective calcAntiGravity methods of other
 * classes, adds up the total forces, and returns this
 * as an AntiGravity object.
 */
public class AntiGravityManager extends AbstractManager {

    EnemyManagerInterface enemyManagerInterface;
    EnemyBulletManager  enemyBulletManager;

    /**
     * Create a new AntiGravityManager object.
     * @param ar        your AdvancedRobot.
     * @param emi       object implementing the EnemyManagerInterface.
     * @param ebm       an EnemyBulletManager object.
     * @param tsi       object implementing the TargetStrategyInterface.
     */
    public AntiGravityManager(
            AdvancedRobot ar,
            EnemyManagerInterface emi,
            EnemyBulletManager ebm,
            TargetStrategyInterface tsi) {

        super(ar, tsi);
        enemyManagerInterface = emi;
        enemyBulletManager = ebm;
    }

    /** Override: no reinitialization required. */
    public void reinitialize() {}
    /** Override: no turn-related functionality. */
    public void takeTurn() {}


    /**
     * Calculates the total anti gravity force
     * from walls, robots, etc, on your robot.
     */
    public AntiGravity calcAntiGravity() {

        Point p = enemyBulletManager.calcAntiGravity();
        p.add(BattleField.calcAntiGravity(targets.getTarget()));
        p.add(enemyManagerInterface.calcAntiGravity());
        return new AntiGravity(p);
    }
}
