package tzu.util;
import tzu.intel.*;

/**
 * Used to sort enemy robots by their difficulty level.
 * This comparator should sort from most difficult to least.
 */
public final class CompareByDifficulty implements java.util.Comparator {

    public int compare(Object o1, Object o2) {

        Bot a = (Bot)o1;
        Bot b = (Bot)o2;
        return (int)(a.getDiedBeforeMePct() - b.getDiedBeforeMePct());
    }

    public boolean equals(Object o1, Object o2) {
        return (compare(o1, o2) == 0);
    }
}
