// RamTrackSurfer (C) 2006 Kim, Tae-gyoon (Stelo Kim)

//
// features:
// linear targeting
// circular targeting
// wavesurf
// on hit, try to avoid it.
//
package stelo;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;     // for Point2D's
import java.lang.*;         // for Double and Integer objects
import java.util.ArrayList; // for collection of waves

import java.awt.Color;

public class RamTrackSurfer extends AdvancedRobot {
	private boolean hit = false;
	private double lastAbsBearing;
	private double enemyX, enemyY;
	
	private boolean forward = true;
	
	private double lastEnemyHeading;
	private double lastW;
	private double lastEnemyVelocity;
	
	private double scantime;
	private double radarturn = 1;
	private double numFire = 0;
	private double numHit = 0;
	
    public static int BINS = 47;
    public static double _surfStats[] = new double[BINS];
    public Point2D.Double _myLocation;     // our bot's location
    public Point2D.Double _enemyLocation;  // enemy bot's location

    public ArrayList _enemyWaves;
    public ArrayList _surfDirections;
    public ArrayList _surfAbsBearings;

    public static double _oppEnergy = 100.0;

   /** This is a rectangle that represents an 800x600 battle field,
    * used for a simple, iterative WallSmoothing method (by PEZ).
    * If you're not familiar with WallSmoothing, the wall stick indicates
    * the amount of space we try to always have on either end of the tank
    * (extending straight out the front or back) before touching a wall.
    */
    public static Rectangle2D.Double _fieldRect
        = new java.awt.geom.Rectangle2D.Double(18, 18, 1000 - 36, 1000 - 36);
    public static double WALL_STICK = 160; // 160
	private static int ticksSinceMyFire = 1;
	private static double sumEnemyVelocity = 0;
	private static double averageEnemyVelocity = 0;

    public void run() {
		setColors(new Color(150, 0, 150), new Color(150, 75, 150), new Color(255, 127, 255));

		_fieldRect.height = getBattleFieldHeight() - 36;
		_fieldRect.width = getBattleFieldWidth() - 36;		
		
        _enemyWaves = new ArrayList();
        _surfDirections = new ArrayList();
        _surfAbsBearings = new ArrayList();

        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
		
		out.println("Click paint to see debug drawings.");

        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
			if (getGunHeat() == 0 && Math.random() < 0.01)
				randomMove();
	    // turnGunRightRadians(Double.POSITIVE_INFINITY); // stelo
        } while (true);



    }

    public void onScannedRobot(ScannedRobotEvent e) {
        _myLocation = new Point2D.Double(getX(), getY());

        double lateralVelocity = getVelocity()*Math.sin(e.getBearingRadians());
        double absBearing = e.getBearingRadians() + getHeadingRadians();
		
		lastAbsBearing = absBearing;
		if (!hit)
			setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * 2); // 2 original
		hit = false;
		// Try to stay equa-distance to the target -  a slight movement towards
		// target would help with corner death, but no room.
		// setTurnRightRadians(e.getBearingRadians() + Math.PI/2);

        // setTurnRadarRightRadians(Utils.normalRelativeAngle(absBearing - getRadarHeadingRadians()) * getOthers()); // 2 original

        // setTurnGunRightRadians(Utils.normalRelativeAngle(absBearing - getGunHeadingRadians()) * 2); // stelo


        _surfDirections.add(0,
            new Integer((lateralVelocity >= 0) ? 1 : -1));
//        _surfAbsBearings.add(0, new Double(absBearing + Math.PI));
        _surfAbsBearings.add(0, new Double(absBearing + Math.PI + 2 * (absBearing - lastAbsBearing)));


        double bulletPower = _oppEnergy - e.getEnergy();
		
	    if (bulletPower < 3.01 && bulletPower > 0.09 && _surfDirections.size() > 2) {
            EnemyWave ew = new EnemyWave();
            ew.fireTime = getTime() - 1;
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.distanceTraveled = bulletVelocity(bulletPower);
            ew.direction = ((Integer)_surfDirections.get(2)).intValue();
            ew.directAngle = ((Double)_surfAbsBearings.get(2)).doubleValue();
            ew.fireLocation = (Point2D.Double)_enemyLocation.clone(); // last tick

            _enemyWaves.add(ew);
			out.println("Enemy bulletPower: " + bulletPower);
			//doSurfing();
        }

        _oppEnergy = e.getEnergy();

        // update after EnemyWave detection, because that needs the previous
        // enemy location as the source of the wave
        _enemyLocation = project(_myLocation, absBearing, e.getDistance());

        updateWaves();

		//randomMove();
        doSurfing();

		//if (getDistanceRemaining() == 0) // always move
		//	setAhead(1);

        // gun code would go here...

		double maxPower = 1.8;
		double divisor = 4;
		if (e.getDistance() > 300)
			divisor = 8;
			
		if (e.getDistance() < 100) maxPower = 3.0;
		
		bulletPower = Math.min(getEnergy() - 2, e.getEnergy() / divisor);
		
		if (bulletPower <= 0)
			bulletPower = 0.1;
		else if (bulletPower > maxPower)
			bulletPower = maxPower;
		// CircularTargeting (quadratic)
		
	
		radarturn=-radarturn;
		double w=e.getHeadingRadians()-lastEnemyHeading;
		// System.out.println(dw);
		
		lastEnemyHeading=e.getHeadingRadians();
		lastW = w;
		
		enemyX = getX() + e.getDistance() * Math.sin(absBearing);
		enemyY = getY() + e.getDistance() * Math.cos(absBearing);
			
		{
			double absbearing=e.getBearingRadians()+getHeadingRadians();
			double eX=e.getDistance()*Math.sin(absbearing);
			double eY=e.getDistance()*Math.cos(absbearing);

			double db=0;
			double ww=lastEnemyHeading;  // enemy's starting heading
			//double v = e.getVelocity();
			double v = averageEnemyVelocity;
			//if (Math.random() < 0.3) v = Math.random() * 8.0 - 4.0; // random velocity
			
			do
			{
				// db+=11; //11 is the velocity of a fire(3) bullet.
				db += (20.0 - 3.0 * bulletPower);
				double dx=v*Math.sin(ww);
				double dy=v*Math.cos(ww);
				ww+=w;  // turn w radians for next step
				
				eX+=dx;
				eY+=dy;
				
				
			}while (db< Point2D.distance(0,0,eX,eY));	// The bullet travelled far enough to hit our target!
		
			setTurnGunRightRadians(Math.asin(Math.sin(Math.atan2(eX, eY) - getGunHeadingRadians())));
			// setTurnRightRadians(e.getBearingRadians() + .5*Math.PI);		
			
		}	

		// public void fire(double power) Fires a bullet. The valid range for power is .1 to 3. The bullet will travel in the direction the gun is pointing. The bullet will do (4 * power) damage if it hits another robot. If power is greater than 1, it will do an additional 2 * (power - 1) damage. You will get (3 * power) back if you hit the other robot. An event will be generated when the bullet hits a robot, wall, or other bullet. This call executes immediately. 		
		if (getEnergy() > 0.1 && getGunHeat() == 0 ) {										
			setFire(bulletPower);
			numFire++;
			System.out.println("Hit rate: " + (numHit / numFire) + "\tDistance: " + e.getDistance());
		}
		if (ticksSinceMyFire > 16) {
			averageEnemyVelocity = limit(-8, sumEnemyVelocity / ticksSinceMyFire, 8);
			ticksSinceMyFire = 0;
			sumEnemyVelocity = 0;
		}
	
		ticksSinceMyFire++;
		sumEnemyVelocity += e.getVelocity();
		lastEnemyVelocity = e.getVelocity();
    }

    public void updateWaves() {
        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

            ew.distanceTraveled = (getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled >
                _myLocation.distance(ew.fireLocation) + 50) {
                _enemyWaves.remove(x);
                x--;
            }
        }
    }


    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000; // I juse use some very big number here
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

            if (distance > ew.bulletVelocity && distance < closestDistance) {
            // if (distance < closestDistance) {
		
                surfWave = ew;
                closestDistance = distance;
            }
        }

        return surfWave;
    }


    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, calculate the index into our stat array for that factor.
    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = (absoluteBearing(ew.fireLocation, targetLocation)
            - ew.directAngle);
        double factor = Utils.normalRelativeAngle(offsetAngle)
            / maxEscapeAngle(ew.bulletVelocity) * ew.direction;

        return (int)limit(0,
            (factor * ((BINS - 1) / 2)) + ((BINS - 1) / 2),
            BINS - 1);
    }

    // Given the EnemyWave that the bullet was on, and the point where we
    // were hit, update our stat array to reflect the danger in that area.
    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = getFactorIndex(ew, targetLocation);

        for (int x = 0; x < BINS; x++) {
            // for the spot bin that we were hit on, add 1;
            // for the bins next to it, add 1 / 2;
            // the next one, add 1 / 5; and so on...
            _surfStats[x] += 1.0 / (Math.pow(index - x, 2) + 1);
        }
    }
 
    public void onHitByBullet(HitByBulletEvent e) {
		double absoluteBearing = getHeading() + e.getBearing();
	
		// System.out.println("I'm hit from bearing " + absoluteBearing);
		
		// turn radar to the bullet, try to avoid and attack it.
		// if (getRadarTurnRemaining() == 0.0 && getGunHeat() == 0.0)
		turnRadarRightRadians(Utils.normalRelativeAngle(e.getBearingRadians() + getHeadingRadians() - getRadarHeadingRadians()));

		hit = true;
		
        // If the _enemyWaves collection is empty, we must have missed the
        // detection of this wave somehow.
        if (!_enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(
                e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;

            // look through the EnemyWaves, and find one that could've hit us.
            for (int x = 0; x < _enemyWaves.size(); x++) {
                EnemyWave ew = (EnemyWave)_enemyWaves.get(x);

                if (Math.abs(ew.distanceTraveled -
                    _myLocation.distance(ew.fireLocation)) < 50
                    && Math.round(bulletVelocity(e.getBullet().getPower()) * 10)
                       == Math.round(ew.bulletVelocity * 10)) {
                    hitWave = ew;
                    break;
                }
            }

            if (hitWave != null) {
                logHit(hitWave, hitBulletLocation);

                // We can remove this wave now, of course.
                _enemyWaves.remove(_enemyWaves.lastIndexOf(hitWave));
            }
        }
    }


    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
        double predictedVelocity = getVelocity();
        double predictedHeading = getHeadingRadians();
        double maxTurning, moveAngle, moveDir;

        int counter = 0; // number of ticks in the future
        boolean intercepted = false;

        do {    // the rest of these code comments are rozu's
            moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(surfWave.fireLocation,
                predictedPosition) + (direction * (Math.PI/2)), direction)
                - predictedHeading;
            moveDir = 1;

            if(Math.cos(moveAngle) < 0) {
                moveAngle += Math.PI;
                moveDir = -1;
            }

            moveAngle = Utils.normalRelativeAngle(moveAngle);

            // maxTurning is built in like this, you can't turn more then this in one tick
            maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle(predictedHeading
                + limit(-maxTurning, moveAngle, maxTurning));

            // this one is nice ;). if predictedVelocity and moveDir have
            // different signs you want to breack down
            // otherwise you want to accelerate (look at the factor "2")
            predictedVelocity += 
                (predictedVelocity * moveDir < 0 ? 2 * moveDir : moveDir); // 2 original

            predictedVelocity = limit(-8, predictedVelocity, 8);
			// predictedVelocity = limit(-5, predictedVelocity, 5); // stelo

            // calculate the new predicted position
            predictedPosition = project(predictedPosition, predictedHeading, 
                predictedVelocity);

            counter++;

            if (predictedPosition.distance(surfWave.fireLocation) <
                surfWave.distanceTraveled + (counter * surfWave.bulletVelocity)
                + surfWave.bulletVelocity) {
                intercepted = true;
            }
        } while(!intercepted && counter < 500); // 500 original

        return predictedPosition;
    }


    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = getFactorIndex(surfWave,
            predictPosition(surfWave, direction));

        return _surfStats[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = getClosestSurfableWave();

        if (surfWave == null) { return; }

        double dangerLeft = checkDanger(surfWave, -1);
        double dangerRight = checkDanger(surfWave, 1);

        double goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);

        if (dangerLeft < dangerRight) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2.1), -1); // 2
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2.1), 1);
        }

        setBackAsFront(this, goAngle);
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity, directAngle, distanceTraveled;
        int direction;

        public EnemyWave() { }
    }

	// this is time-consuming!
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
		double amount = 0.05;
		int count = 0;
		
		if (orientation < 0) amount *= -1;
	    while (count < 450 && !_fieldRect.contains(project(botLocation, angle, WALL_STICK))) {
            angle += amount; // *0.05
			count++;
        }

		
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, 
        double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return (20.0 - (3.0*power));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
		double x, y, w, h;
		x = robot.getX();
		y = robot.getY();
		w = robot.getBattleFieldWidth();
		h = robot.getBattleFieldHeight();
		
		double moveAmount = 48.0 + Math.random() * 50.0; // 100.0

        double angle =
            Utils.normalRelativeAngle(goAngle - robot.getHeadingRadians());
		
		robot.setMaxVelocity(8);
		if ( (x < w / 4 || x > w * 3 / 4) && (y < h / 4 || y > h * 3 / 4) ) {
		// move short distance in corners
			moveAmount = 60;
			robot.setMaxVelocity(7);
		}
        if (Math.abs(angle) > (Math.PI/2)) {
            if (angle < 0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
		    robot.setBack(moveAmount); // 100
        } else {
        	if (angle < 0) {
                robot.setTurnLeftRadians(-1*angle);
           	} else {
                robot.setTurnRightRadians(angle);
           	}
		    robot.setAhead(moveAmount); // 100
        }

		// Hit the brake pedal hard if we need to turn sharply
		robot.setMaxVelocity(Math.abs(robot.getTurnRemaining()) > 30 ? 0 : 8);
    }

	public void onBulletHit(BulletHitEvent event) {
		numHit++;
	}
	
	public void onSkippedTurn(SkippedTurnEvent event) {
		out.println("onSkippedTurn");
		randomMove();
	}

	private void randomMove() {
		if (getDistanceRemaining() > 0) return;
        EnemyWave surfWave = getClosestSurfableWave();
		double goAngle;
        if (surfWave == null)
			goAngle = Math.random() * Math.PI * 2;
		else
			goAngle = absoluteBearing(surfWave.fireLocation, _myLocation);
						
       //if (Math.random() < 0.5) {
		if (forward) {
            goAngle = wallSmoothing(_myLocation, goAngle - (Math.PI/2), -1); // 2
        } else {
            goAngle = wallSmoothing(_myLocation, goAngle + (Math.PI/2), 1);
        }
		forward = !forward;
   	    setBackAsFront(this, goAngle);				
	}
	
	public void onPaint(java.awt.Graphics2D g) {
		g.draw3DRect((int) getX() - 32, (int) getY() - 32, 72, 72, true);
		g.draw3DRect((int) enemyX - 32, (int) enemyY - 32, 72, 72, true);
				
        EnemyWave surfWave = null;

        for (int x = 0; x < _enemyWaves.size(); x++) {
            EnemyWave ew = (EnemyWave)_enemyWaves.get(x);
            double distance = _myLocation.distance(ew.fireLocation)
                - ew.distanceTraveled;

			double eX = getX() + distance * Math.sin(ew.directAngle + Math.PI);
			double eY = getY() + distance * Math.cos(ew.directAngle + Math.PI);

			g.draw3DRect((int) eX, (int) eY, 15, 15, true);
        }		
		
	}
}																