package lucasslf.wavesurfing.buffer;

import lucasslf.wavesurfing.EnemyWave;
import lucasslf.wavesurfing.BasicWaveSurfer;

public class SurfBufferL  extends SurfBuffer {
	private static double[][][][]surfStats = new double[BasicWaveSurfer.SEG_BULLET_POWER][BasicWaveSurfer.SEG_VELOCITY][BasicWaveSurfer.SEG_DISTANCE][BasicWaveSurfer.BINS];
	public SurfBufferL(int weight) {
		super(weight);
	}
	public void setSegmentationOn(EnemyWave wave){
		wave.addSegmentedBuffer(getSegmentedBuffer(wave.getSegBulletPower(),wave.getSegLateralVelocity(),wave.getSegInitialDistance()));
	}
	
	
	@Override
	public SegmentedBuffer getSegmentedBuffer(int... args) {
		if(args == null || args.length != 3)
			throw new IllegalArgumentException("args length must be 3");
		return new SegmentedBuffer(surfStats[args[0]][args[1]][args[2]], this.getWeight());
	}

}
