package ags.rougedc.movement;

import static robocode.util.Utils.normalAbsoluteAngle;
import static robocode.util.Utils.normalRelativeAngle;
import ags.rougedc.base.Rules; 
import ags.utils.points.*; 

/**
 * A wallsmoother, based on Voidious's code and adapted a little myself.
 * Modified to always towards the inside of the field
 * 
 * @author Voidious (origional), Alexander Schultz
 */
public class WallSmoother {
    private static double WALL_STICK = 155;
    private java.awt.geom.Rectangle2D.Double _fieldRect;
        
    
    public WallSmoother(Rules rules) {
        _fieldRect = new java.awt.geom.Rectangle2D.Double(18, 18, rules.BATTLEFIELD_WIDTH-36, rules.BATTLEFIELD_HEIGHT-36);
    }
    
    // Smooth the way that matches current movement best
    public double smoothAngle2(AbsolutePoint p, double angle, RelativePoint velocity) {
        double newd1 = smoothAngle(p.x, p.y, angle, 1);
        double newd2 = smoothAngle(p.x, p.y, angle, -1);
        
        double currentDirection;
        if (velocity.magnitude >= 0)
            currentDirection = velocity.direction;
        else
            currentDirection = normalAbsoluteAngle(velocity.direction + Math.PI);
        
        double dd1 = Math.abs(normalRelativeAngle(newd1-currentDirection));
        double dd2 = Math.abs(normalRelativeAngle(newd2-currentDirection));
        if (dd1 <= dd2)
            angle = newd1;
        else
            angle = newd2;
        return angle;
    }
    
    public double smoothAngle(double x, double y, double angle, int orientation) {

        if (angle < 0) { angle += (2*Math.PI); }
        double testX = x + (Math.sin(angle)*WALL_STICK);
        double testY = y + (Math.cos(angle)*WALL_STICK);
        double wallDistanceX = Math.min(x - 18, _fieldRect.width - x + 18);
        double wallDistanceY = Math.min(y - 18, _fieldRect.height - y + 18);
        double testDistanceX = Math.min(testX - 18, _fieldRect.width - testX + 18);
        double testDistanceY = Math.min(testY - 18, _fieldRect.height - testY + 18);

        double adjacent = 0;
        int g = 0;

        while (!_fieldRect.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0 && testDistanceY < testDistanceX) {
                // wall smooth North or South wall
                angle = angle - (((angle) + (2*Math.PI)) % (Math.PI/2));

                if (!(((angle + (2*Math.PI)) % Math.PI) < 0.1 ||
                    Math.PI - ((angle + (2*Math.PI)) % Math.PI) < 0.1)) {
                    angle += (Math.PI/2);
                }
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0 && testDistanceX <= testDistanceY) {
                // wall smooth East or West wall
                angle = angle - (((angle) + (2*Math.PI)) % (Math.PI/2));
                if (((angle + (2*Math.PI)) % Math.PI) < 0.1 ||
                    (Math.PI - ((angle + (2*Math.PI)) % Math.PI) < 0.1)) {
                    angle += (Math.PI/2);
                }
                adjacent = Math.abs(wallDistanceX);
            }

            angle += orientation*(Math.abs(Math.acos(adjacent/WALL_STICK)) + 0.005);

            testX = x + (Math.sin(angle)*WALL_STICK);
            testY = y + (Math.cos(angle)*WALL_STICK);
            testDistanceX = Math.min(testX - 18, _fieldRect.width - testX + 18);
            testDistanceY = Math.min(testY - 18, _fieldRect.height - testY + 18);
        }

        return angle;
    }
}
