
package sgp;

public class AverageLinearAnalyser
{
	private final int BUFFER_SIZE = 120;
	private int delayTime = 60;
	private int oldOffset = 1;
	private DoubleCircularBuffer xBuffer = null;
	private DoubleCircularBuffer yBuffer = null;
	private DoubleCircularBuffer tBuffer = null;

	
	public AverageLinearAnalyser(int theDelayTime)
	{
		delayTime = theDelayTime;
	}
	
	public void reset()
	{
		
	}

	public void update(Coordinate currentPosition, double currentVelocity, double currentHeading_deg)
	{
		double currentTime = (double)Environment.getRobot().getTime();
		if ((xBuffer == null) || (yBuffer == null) || (tBuffer == null))
		{
			xBuffer = new DoubleCircularBuffer(BUFFER_SIZE, currentPosition.x);
			yBuffer = new DoubleCircularBuffer(BUFFER_SIZE, currentPosition.y);
			tBuffer = new DoubleCircularBuffer(BUFFER_SIZE, currentTime);
			oldOffset = 0;
		}
		else
		{
			xBuffer.add(currentPosition.x);
			yBuffer.add(currentPosition.y);
			tBuffer.add(currentTime);
			if (tBuffer.get(oldOffset) > (currentTime - delayTime))
			{
				oldOffset++;
			}
			else if (tBuffer.get(oldOffset) < (currentTime - delayTime))
			{
				oldOffset--;
			}
						
			if (oldOffset < 0) oldOffset = 0;
			if (oldOffset > (BUFFER_SIZE - 1)) oldOffset = (BUFFER_SIZE - 1);
			
			
		}
	}
	
	public Coordinate getOldPosition()
	{
		if ((xBuffer == null) || (yBuffer == null)) return null;
		
		return new Coordinate
		(
			xBuffer.get(oldOffset),
			yBuffer.get(oldOffset)
		);
	}
	
	public double getOldTimeDifference()
	{
		double timeDifference = Environment.getRobot().getTime() - tBuffer.get(oldOffset);
		return Math.max(timeDifference, 1.0);
	}
	
}
