
package sgp;
import robocode.*;

public class PolarPatternIntercept extends LinearIntercept
{
	PolarPatternAnalyser analyser = null;
	
	int closestMatchIndex = 0;
	double targetRelativeHeading = 0;
	double initialDistance = 0;
	double initialBearing_rad = 0;
	double initialShooterHeading_rad = 0;
	
	/**
	 * Constructor for PolarPatternIntercept.
	 */
	public PolarPatternIntercept(PolarPatternAnalyser theAnalyser)
	{
		super();
		analyser = theAnalyser;
	}

	/**
	 * Constructor for PolarPatternIntercept.
	 * @param tRadius
	 */
	public PolarPatternIntercept(double tRadius, PolarPatternAnalyser theAnalyser)
	{
		super(tRadius);
		analyser = theAnalyser;
	}
	
	public void calculate
		(
			double xb,
			double yb,
			double xt,
			double yt,
			double tHeading,
			double vt,
			double bPower,
			double angularVelocity_deg_per_sec
		)
	{
		Coordinate bulletStartPosition = new Coordinate(xb, yb);
		Coordinate targetStartPosition = new Coordinate(xt, yt);
		initialDistance = targetStartPosition.distanceFrom(bulletStartPosition);
		initialBearing_rad = Math.toRadians(bulletStartPosition.headingTo(targetStartPosition));
		initialShooterHeading_rad = Environment.getHeadingRadians();
		targetRelativeHeading = tHeading - Math.toDegrees(initialBearing_rad);
		super.calculate(xb, yb, xt, yt, tHeading, vt, bPower, angularVelocity_deg_per_sec);
	}


	protected Coordinate getEstimatedPosition(double time)
	{
		closestMatchIndex = analyser.eventBuffer.getClosestMatchIndex(initialDistance, targetRelativeHeading, targetVelocity, time);

		ScanEvent e = analyser.eventBuffer.getEvent(closestMatchIndex, (int)time);
		
		ScanEvent latestEvent = analyser.eventBuffer.eventArray[closestMatchIndex];
		
		double r;
		double angle_rad;
		
		Coordinate offset;
		
		if (e != null) 
		{
			offset = new Coordinate(e.position.minus(latestEvent.position));
			offset.rotate(e.relativeHeading_deg - latestEvent.relativeHeading_deg);
		}
		else
		{
			offset = new Coordinate();
		}
		
		
				
		Coordinate estimatedPosition = targetStartingPoint.plus(offset);

//		System.out.println(offset);
		
		return Strategy.limitToBattleField(estimatedPosition);
	}
	

}
