/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import java.util.ArrayList;
import robocode.Bullet;
import syl.core.BaseRobot;
import syl.core.Component;
import syl.core.Enemy;
import syl.core.RobotListenerAdapter;
import syl.fire.AngleDifferenceFireStrategy;
import syl.fire.FireStrategy;
import syl.fire.JiggleFireStrategy;
import syl.fire.PatternFireStrategy;
import syl.fire.PredictiveFireStrategy;
import syl.fire.SimpleFireStrategy;
import syl.util.Log;

public class FireStrategyManager
extends RobotListenerAdapter
implements Component {
    private BaseRobot robot;
    private ArrayList fireStrategies = new ArrayList();
    private FireStrategy currentFireStrategy;
    private Enemy currentEnemy;

    public FireStrategyManager(BaseRobot robot) {
        this.robot = robot;
    }

    public void initialize() {
        this.robot.addRobotListener(this);
        this.fireStrategies.add(new PredictiveFireStrategy(this.robot));
        this.fireStrategies.add(new SimpleFireStrategy(this.robot));
        this.fireStrategies.add(new JiggleFireStrategy(this.robot));
        this.fireStrategies.add(new AngleDifferenceFireStrategy(this.robot));
        this.fireStrategies.add(new PatternFireStrategy(this.robot));
        int i = 0;
        while (i < this.fireStrategies.size()) {
            ((FireStrategy)this.fireStrategies.get(i)).initialize();
            ++i;
        }
    }

    public void cleanUp() {
        int i = 0;
        while (i < this.fireStrategies.size()) {
            ((FireStrategy)this.fireStrategies.get(i)).cleanUp();
            ++i;
        }
    }

    public FireStrategy getFireStrategy(Enemy enemy) {
        if (enemy == null) {
            return null;
        }
        if (enemy != this.currentEnemy) {
            this.currentEnemy = enemy;
            this.currentFireStrategy = null;
        }
        double highestHitRatio = -1.0;
        boolean change = false;
        if (this.currentFireStrategy != null) {
            highestHitRatio = this.currentFireStrategy.getHitRatio(enemy);
        }
        int i = 0;
        while (i < this.fireStrategies.size()) {
            double hitRatio;
            FireStrategy fireStrategy = (FireStrategy)this.fireStrategies.get(i);
            if (fireStrategy != this.currentFireStrategy && (hitRatio = fireStrategy.getHitRatio(enemy)) > highestHitRatio) {
                highestHitRatio = hitRatio;
                this.currentFireStrategy = fireStrategy;
                change = true;
            }
            ++i;
        }
        if (change) {
            Log.log((Object)this, true, this.currentFireStrategy + " with hitratio " + highestHitRatio + " selected for enemy " + enemy.getName() + ".");
        }
        return this.currentFireStrategy;
    }

    public boolean doFire(Enemy target) {
        Bullet bullet = this.currentFireStrategy.fireBullet(target);
        int i = 0;
        while (i < this.fireStrategies.size()) {
            FireStrategy fireStrategy = (FireStrategy)this.fireStrategies.get(i);
            if (fireStrategy.isEvasiveFireStrategy()) {
                if (bullet != null) {
                    fireStrategy.fireVirtualBullet(target);
                }
            } else {
                fireStrategy.fireVirtualBullet(target);
            }
            ++i;
        }
        return bullet != null;
    }
}

