/*
 * Decompiled with CFR 0.152.
 */
package syl.movement;

import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.core.RobotListenerAdapter;
import syl.util.Angle;
import syl.util.Coordinate;

public abstract class MovementStrategy
extends RobotListenerAdapter {
    private static final int MOVEMENT_DISTANCE = 50;
    protected static final double MAX_VELOCITY = 8.0;
    private BaseRobot robot;
    private double velocity = 8.0;

    public MovementStrategy(BaseRobot robot) {
        this.robot = robot;
    }

    public abstract void initialize();

    public abstract void cleanUp();

    public abstract void doMovement(Enemy var1);

    public BaseRobot getRobot() {
        return this.robot;
    }

    public static void goTo(BaseRobot robot, Coordinate targetCoordinate, double velocity) {
        Coordinate currentCoordinate = robot.getCoordinate();
        double angle = currentCoordinate.getAngle(targetCoordinate);
        double direction = MovementStrategy.turnTo(robot, angle);
        robot.setMaxVelocity(velocity);
        robot.setAhead(50.0 * direction);
    }

    public static int turnTo(BaseRobot robot, double angle) {
        int dir = 1;
        double ang = Angle.toRelativeAngle(angle - robot.getHeading());
        if (ang > 90.0) {
            ang -= 180.0;
            dir = -1;
        } else if (ang < -90.0) {
            ang += 180.0;
            dir = -1;
        }
        robot.setTurnRight(ang);
        return dir;
    }
}

