/*
 * Decompiled with CFR 0.152.
 */
package bndl;

import bndl.Enemy;
import java.util.Iterator;
import java.util.LinkedList;
import robocode.Bullet;

public class BulletList {
    LinkedList bullets;
    Enemy target;
    int hits;
    int rounds;

    public BulletList(Enemy enemy) {
        this.target = enemy;
        this.bullets = new LinkedList();
        this.rounds = 0;
        this.hits = 0;
    }

    public void add(Bullet bullet) {
        ++this.rounds;
        this.bullets.add(bullet);
    }

    public void removeOld() {
        Bullet bullet = null;
        Iterator iterator = this.bullets.iterator();
        while (iterator.hasNext()) {
            bullet = (Bullet)iterator.next();
            if (bullet == null) {
                iterator.remove();
                continue;
            }
            if (bullet.isActive()) continue;
            if (bullet.getVictim() != null && bullet.getVictim().equals(this.target.getName())) {
                ++this.hits;
            }
            iterator.remove();
        }
    }

    public void adjustForRobotDeath() {
        this.removeOld();
        this.rounds -= this.bullets.size();
        this.bullets.clear();
    }

    public double getHitRate() {
        if (this.rounds != 0) {
            return 1.0 * (double)this.hits / (double)this.rounds;
        }
        return 0.0;
    }

    public int getHits() {
        return this.hits;
    }

    public int getRounds() {
        return this.rounds;
    }

    public String toString() {
        String string = "Current size: " + this.bullets.size() + " Hits: " + this.hits + " Rounds: " + this.rounds;
        return string;
    }
}

