/*
 * Decompiled with CFR 0.152.
 */
package eat;

import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.ScannedRobotEvent;

public final class HumblePieLite
extends AdvancedRobot {
    static final double ZERO = 0.0;
    static final double A_090 = 1.5707963267948966;
    static final double A_180 = Math.PI;
    static final double A_360 = Math.PI * 2;
    static final double SCAN_ARC = 0.39269908169872414;
    static final double MAX_BULLET_SPEED = 20.0;
    static final double MAX_BULLET_POWER = 3.0;
    static final double MAX_SPEED = 8.0;
    static final double AIM_TOLERANCE = 18.0;
    static final int FACTOR_SIZE = 21;
    static final int[][][][][] aimFactor = new int[3][3][3][4][21];
    static double targetX;
    static double targetPrevX;
    static double targetY;
    static double targetPrevY;
    static double targetPrevStoppedX;
    static double targetPrevStoppedY;
    static double targetPrevSpeed;
    static double targetSpeed;
    static double targetHeading;
    static double targetGameHeading;
    static double targetDistance;
    static double targetPrevChgSpeed;
    static double targetChgSpeed;
    static double targetChgHeading;
    static long targetLastUpdate;
    static double targetMove;

    public void run() {
        double d = this.getBattleFieldWidth() / 2.0;
        double d2 = this.getBattleFieldHeight() / 2.0;
        targetPrevStoppedX = 0.0;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Math.PI * 2);
        do {
            int n;
            int n2;
            int n3;
            double d3 = HumblePieLite.calcHeading(targetX, targetY, d, d2);
            double d4 = HumblePieLite.calcDistance(targetX, targetY, d, d2) * 1.95;
            double d5 = HumblePieLite.calcX(targetX, d3, d4);
            double d6 = HumblePieLite.calcY(targetY, d3, d4);
            d4 = HumblePieLite.calcDistance(this.getX(), this.getY(), d5, d6);
            d3 = HumblePieLite.plusMinus180(this.getHeadingRadians(), HumblePieLite.calcHeading(this.getX(), this.getY(), d5, d6));
            if (Math.abs(d3) > 1.5707963267948966) {
                d3 += d3 > 1.5707963267948966 ? -Math.PI : Math.PI;
                d4 *= -1.0;
            }
            this.setTurnRightRadians(d3);
            this.setAhead(d4);
            double d7 = Math.min(3.0, this.getEnergy() / 3.0);
            double d8 = targetSpeed == 0.0 ? 0.1 : targetSpeed;
            d3 = targetHeading;
            long l = 0L;
            double d9 = 20.0 - 3.0 * d7;
            long l2 = Math.round(targetDistance / d9);
            d5 = targetX;
            d6 = targetY;
            do {
                ++l;
                d3 = HumblePieLite.normalizeAngle(d3 + targetChgHeading);
                d8 = HumblePieLite.limit(d8 + 1.0, 0.0, 8.0);
                d5 = HumblePieLite.calcX(d5, d3, d8);
                d6 = HumblePieLite.calcY(d6, d3, d8);
                l2 = Math.round(HumblePieLite.calcDistance(this.getX(), this.getY(), d5, d6) / d9);
            } while (d8 > 0.0 && l < l2 && d5 > 0.0 && d5 < this.getBattleFieldWidth() && d6 > 0.0 && d6 < this.getBattleFieldHeight());
            int n4 = targetSpeed >= 7.0 ? 0 : (n3 = targetSpeed < 1.0 ? 1 : 2);
            int n5 = targetChgSpeed < 0.0 ? 0 : (n2 = targetChgSpeed > 0.0 ? 2 : 1);
            int n6 = targetDistance <= 100.0 ? 0 : (n = targetDistance > 500.0 ? 2 : 1);
            int n7 = targetMove < 36.0 ? 0 : (targetMove < 100.0 ? 1 : (targetMove < 300.0 ? 2 : 3));
            int n8 = 20;
            int n9 = 0;
            while (n9 < 21) {
                if (aimFactor[n3][n2][n][n7][n9] > aimFactor[n3][n2][n][n7][n8]) {
                    n8 = n9;
                }
                ++n9;
            }
            double d10 = HumblePieLite.calcHeading(this.getX(), this.getY(), targetX, targetY);
            d3 = HumblePieLite.plusMinus180(d10, HumblePieLite.calcHeading(this.getX(), this.getY(), d5, d6));
            this.setTurnGunRightRadians(HumblePieLite.plusMinus180(this.getGunHeadingRadians(), HumblePieLite.normalizeAngle(d10 + d3 * (((double)n8 - 10.0) / 10.0))));
            if (Math.abs(Math.tan(this.getGunTurnRemainingRadians())) * HumblePieLite.calcDistance(this.getX(), this.getY(), d5, d6) < 18.0 && this.getGunHeat() == 0.0) {
                this.addCustomEvent(new DodgeObserver(d9, d5, d6, d10, d3));
                this.setFire(d7);
            }
            this.execute();
        } while (this.getOthers() > 0);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        double d = scannedRobotEvent.getHeadingRadians();
        double d2 = scannedRobotEvent.getVelocity();
        targetDistance = scannedRobotEvent.getDistance();
        targetChgHeading = HumblePieLite.plusMinus180(targetGameHeading, d) / (double)(this.getTime() - targetLastUpdate);
        targetGameHeading = d;
        if (d2 < 0.0) {
            d2 = Math.abs(d2);
            d = HumblePieLite.normalizeAngle(d + Math.PI);
        }
        targetPrevChgSpeed = targetChgSpeed;
        targetChgSpeed = (d2 - targetSpeed) / (double)(this.getTime() - targetLastUpdate);
        targetHeading = d;
        targetPrevSpeed = targetSpeed;
        targetSpeed = d2;
        d = HumblePieLite.normalizeAngle(this.getHeadingRadians() + scannedRobotEvent.getBearingRadians());
        targetPrevX = targetX;
        targetPrevY = targetY;
        targetX = HumblePieLite.calcX(this.getX(), d, targetDistance);
        targetY = HumblePieLite.calcY(this.getY(), d, targetDistance);
        targetLastUpdate = this.getTime();
        if (targetPrevStoppedX == 0.0 || targetChgSpeed >= 0.0 && targetPrevChgSpeed < 0.0 && targetPrevSpeed <= 3.0) {
            targetPrevStoppedX = targetX;
            targetPrevStoppedY = targetY;
            targetMove = 0.0;
        } else {
            targetMove += HumblePieLite.calcDistance(targetPrevX, targetPrevY, targetX, targetY);
        }
        d = HumblePieLite.plusMinus180(this.getRadarHeadingRadians(), d);
        this.setTurnRadarRightRadians(d + (d > 0.0 ? 0.39269908169872414 : -0.39269908169872414));
    }

    static double normalizeAngle(double d) {
        if ((d %= Math.PI * 2) < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    static double plusMinus180(double d, double d2) {
        return (d2 - d + Math.PI * 7) % (Math.PI * 2) - Math.PI;
    }

    static double calcHeading(double d, double d2, double d3, double d4) {
        return HumblePieLite.normalizeAngle(Math.atan2(d3 - d, d4 - d2));
    }

    static double calcDistance(double d, double d2, double d3, double d4) {
        double d5 = d4 - d2;
        double d6 = d3 - d;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    static double calcX(double d, double d2, double d3) {
        return d + Math.sin(d2) * d3;
    }

    static double calcY(double d, double d2, double d3) {
        return d + Math.cos(d2) * d3;
    }

    static double limit(double d, double d2, double d3) {
        return Math.max(Math.min(d, d3), d2);
    }

    final class DodgeObserver
    extends Condition {
        final double bulletStartX;
        final double bulletStartY;
        final double bulletSpeed;
        final long fireTime;
        final double originalHeadingToTarget;
        final double originalGunAngle;
        final int s;
        final int a;
        final int d;
        final int m;

        public DodgeObserver(double d, double d2, double d3, double d4, double d5) {
            super("DodgeObserver", 1);
            int n = targetSpeed >= 7.0 ? 0 : (this.s = targetSpeed < 1.0 ? 1 : 2);
            int n2 = targetChgSpeed < 0.0 ? 0 : (this.a = targetChgSpeed > 0.0 ? 2 : 1);
            int n3 = targetDistance <= 100.0 ? 0 : (this.d = targetDistance > 500.0 ? 2 : 1);
            this.m = targetMove < 36.0 ? 0 : (targetMove < 100.0 ? 1 : (targetMove < 300.0 ? 2 : 3));
            this.bulletStartX = HumblePieLite.this.getX();
            this.bulletStartY = HumblePieLite.this.getY();
            this.fireTime = HumblePieLite.this.getTime();
            this.bulletSpeed = d;
            this.originalHeadingToTarget = d4;
            this.originalGunAngle = d5;
        }

        public boolean test() {
            double d = this.bulletSpeed * (double)(HumblePieLite.this.getTime() - this.fireTime) - HumblePieLite.calcDistance(this.bulletStartX, this.bulletStartY, targetX, targetY);
            if (d > 18.0 || HumblePieLite.this.getOthers() == 0) {
                HumblePieLite.this.removeCustomEvent(this);
            } else if (Math.abs(d) <= 18.0) {
                int[] nArray = aimFactor[this.s][this.a][this.d][this.m];
                int n = (int)Math.round((this.originalGunAngle != 0.0 ? HumblePieLite.limit(HumblePieLite.plusMinus180(this.originalHeadingToTarget, HumblePieLite.calcHeading(this.bulletStartX, this.bulletStartY, targetX, targetY)) / this.originalGunAngle, -1.0, 1.0) : 0.0) * 10.0 + 10.0);
                nArray[n] = nArray[n] + 1;
            }
            return false;
        }
    }
}

