/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.Message;
import execution.MessageRouter;
import execution.Sequencer;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import math.Fath;
import math.Maths;
import math.Vect2d;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.robotinterfaces.IAdvancedEvents;
import robocode.robotinterfaces.IBasicEvents3;
import robocode.robotinterfaces.peer.IAdvancedRobotPeer;
import robocode.util.Utils;
import sim.Bot;
import sim.Data;
import sim.EnemyWave;
import sim.SelfWave;
import sim.Stat;

public class EventAdaptor
implements IBasicEvents3,
IAdvancedEvents {
    private IAdvancedRobotPeer _peer;
    private MessageRouter _router;
    private Sequencer _sequencer;

    public EventAdaptor(MessageRouter router, Sequencer sequencer) {
        this._router = router;
        this._sequencer = sequencer;
    }

    public void SetPeer(IAdvancedRobotPeer peer) {
        this._peer = peer;
    }

    public void Update() {
        long time = this._peer.getTime();
        this._router.prepare(Message.Kind.Update).at(time).send();
    }

    public void onStatus(StatusEvent e) {
        long time = e.getTime();
        if (time > 0L) {
            long prevTime = Data.Battle.Time;
            Data.Battle.OverallTime += time - prevTime;
        } else {
            ++Data.Battle.OverallTime;
        }
        Data.Battle.Time = time;
        if (time == 0L) {
            Data.Robots.Self = new Bot(this._peer.getName());
            int roundNum = this._peer.getRoundNum();
            if (roundNum == 0) {
                Data.Battle.BattleFieldHeight = this._peer.getBattleFieldHeight();
                Data.Battle.BattleFieldWidth = this._peer.getBattleFieldWidth();
                Data.Battle.MaxDistance = Math.hypot(Data.Battle.BattleFieldWidth - Data.Battle.RobotWidth, Data.Battle.BattleFieldHeight - Data.Battle.RobotWidth);
                Data.Battle.MaxBulletFlightTime = (int)Math.round(Data.Battle.MaxDistance / Rules.getBulletSpeed((double)3.0)) + 1;
                Data.Battle.GunCoolingRate = this._peer.getGunCoolingRate();
                Data.Battle.InitialGunHeat = this._peer.getGunHeat();
                Data.Battle.StartingEnemyCount = this._peer.getOthers();
                Data.Battle.TotalRounds = this._peer.getNumRounds();
                Data.Battle.LeftWall = new Line2D.Double(0.0, 0.0, 0.0, Data.Battle.BattleFieldHeight);
                Data.Battle.RightWall = new Line2D.Double(Data.Battle.BattleFieldWidth, 0.0, Data.Battle.BattleFieldWidth, Data.Battle.BattleFieldHeight);
                Data.Battle.BottomWall = new Line2D.Double(0.0, 0.0, Data.Battle.BattleFieldWidth, 0.0);
                Data.Battle.TopWall = new Line2D.Double(0.0, Data.Battle.BattleFieldHeight, Data.Battle.BattleFieldWidth, Data.Battle.BattleFieldHeight);
                double fudgeWidth = Data.Battle.HalfRobotWidth - 1.0E-11;
                Data.Battle.LeftWallInner = new Line2D.Double(fudgeWidth, 0.0, fudgeWidth, Data.Battle.BattleFieldHeight);
                Data.Battle.RightWallInner = new Line2D.Double(Data.Battle.BattleFieldWidth - fudgeWidth, 0.0, Data.Battle.BattleFieldWidth - fudgeWidth, Data.Battle.BattleFieldHeight);
                Data.Battle.BottomWallInner = new Line2D.Double(0.0, fudgeWidth, Data.Battle.BattleFieldWidth, fudgeWidth);
                Data.Battle.TopWallInner = new Line2D.Double(0.0, Data.Battle.BattleFieldHeight - fudgeWidth, Data.Battle.BattleFieldWidth, Data.Battle.BattleFieldHeight - fudgeWidth);
                this._router.prepare(Message.Kind.BattleStarted).send();
            }
            this._peer.setAdjustGunForBodyTurn(true);
            this._peer.setAdjustRadarForGunTurn(true);
            this._peer.setAdjustRadarForBodyTurn(true);
            Data.Battle.CurrentRound = roundNum;
            this._router.prepare(Message.Kind.RoundStarted).at(time).set("OverallTime", Data.Battle.OverallTime).set("Round", roundNum).send();
        }
        Bot self = Data.Robots.Self;
        RobotStatus status = e.getStatus();
        double myX = status.getX();
        double myY = status.getY();
        double myVelocity = status.getVelocity();
        double myHeading = status.getHeadingRadians();
        self.Set(Stat.GUN_HEAT, status.getGunHeat());
        self.Set(Stat.ENERGY, status.getEnergy());
        self.Position.setLocation(myX, myY);
        Vect2d headingVector = Vect2d.fromHeading(myHeading);
        this.UpdateHeadingStats(self, myHeading, time);
        this.UpdateVelocityStats(self, myVelocity, headingVector);
        this.UpdatePositionalStats(self, myX, myY);
        this._sequencer.move.remaining = status.getDistanceRemaining();
        this._sequencer.turn.remaining = status.getTurnRemainingRadians();
        this._sequencer.aim.remaining = status.getGunTurnRemainingRadians();
        this._sequencer.scan.remaining = status.getRadarHeadingRadians();
        self.Set(Stat.RADAR_HEADING, status.getRadarHeadingRadians());
        self.Set(Stat.GUN_HEADING, status.getGunHeadingRadians());
        this._router.prepare(Message.Kind.PreUpdate).at(time).send();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        long time = e.getTime();
        Bot enemy = Data.Robots.Enemy(e.getName());
        Bot self = Data.Robots.Self;
        double myX = self.Position.getX();
        double myY = self.Position.getY();
        double myHeading = self.Get(Stat.HEADING);
        double previousX = enemy.Position.getX();
        double previousY = enemy.Position.getY();
        double bearing = e.getBearingRadians();
        double absoluteBearing = Maths.normalAbsoluteAngle(bearing + myHeading);
        double heading = e.getHeadingRadians();
        double distance = e.getDistance();
        double previousEnergy = enemy.Get(Stat.ENERGY);
        double previousVelocity = enemy.Get(Stat.VELOCITY);
        double previousAcceleration = enemy.Get(Stat.ACCELERATION);
        double velocity = e.getVelocity();
        double energy = e.getEnergy();
        enemy.LastUpdated = time;
        enemy.Set(Stat.BEARING, bearing);
        enemy.Set(Stat.ENERGY, energy);
        double x = myX + Fath.sin(absoluteBearing) * distance;
        double y = myY + Fath.cos(absoluteBearing) * distance;
        x = Math.min(Data.Battle.BattleFieldWidth - Data.Battle.HalfRobotWidth, Math.max(Maths.Round(x), Data.Battle.HalfRobotWidth));
        y = Math.min(Data.Battle.BattleFieldHeight - Data.Battle.HalfRobotWidth, Math.max(Maths.Round(y), Data.Battle.HalfRobotWidth));
        Vect2d headingVector = Vect2d.fromHeading(heading);
        this.UpdateHeadingStats(enemy, heading, time);
        this.UpdateVelocityStats(enemy, velocity, headingVector);
        this.UpdatePositionalStats(enemy, x, y);
        this.UpdateRelativePositionalStats(self, enemy, x, y, absoluteBearing, heading, distance, headingVector);
        double dX = myX - x;
        double dY = myY - y;
        double angle = Fath.atan2(dX, dY);
        double myBearing = Maths.normalAbsoluteAngle(angle - heading);
        self.Set(Stat.BEARING, myBearing);
        double myAbsoluteBearing = Maths.normalAbsoluteAngle(myBearing + heading);
        this.UpdateRelativePositionalStats(enemy, self, myX, myY, myAbsoluteBearing, myHeading, distance, self.Heading);
        double wallHitDamage = 0.0;
        double wallDistance = enemy.Get(Stat.WALL_PROXIMITY);
        if (wallDistance == 0.0 && Math.abs(previousVelocity) >= 1.0 && velocity == 0.0 && energy < previousEnergy) {
            wallHitDamage = Rules.getWallHitDamage((double)Maths.Accelerate(previousVelocity, previousAcceleration));
            this._router.prepare(Message.Kind.WallCollision).at(time).about(enemy).send();
        }
        if (enemy.Get(Stat.GUN_HEAT) <= 0.0) {
            double damageTaken = enemy.Get(Stat.DAMAGE_RECEIVED_THIS_TURN);
            double damageReturned = enemy.Get(Stat.ENERGY_RETURNED_THIS_TURN);
            double deltaE = previousEnergy - energy;
            if (damageTaken > 0.0) {
                deltaE -= damageTaken;
            }
            if (damageReturned > 0.0) {
                deltaE += damageReturned;
            }
            if (wallHitDamage > 0.0) {
                deltaE -= wallHitDamage;
            }
            if (Maths.Round(deltaE) > 0.0 && (deltaE <= 3.0 || Utils.isNear((double)deltaE, (double)3.0)) && (deltaE >= 0.1 || Utils.isNear((double)deltaE, (double)0.1))) {
                enemy.Add(Stat.DAMAGE_INVESTED, Rules.getBulletDamage((double)deltaE));
                enemy.Add(Stat.ENERGY_INVESTED, deltaE);
                enemy.Add(Stat.SHOTS_FIRED, 1.0);
                enemy.Set(Stat.GUN_HEAT, Rules.getGunHeat((double)deltaE));
                Point2D.Double enemyPos = new Point2D.Double(previousX, previousY);
                Vect2d bulletVector = Vect2d.fromHeading(enemy.Get(Stat.ABSOLUTEBEARING));
                bulletVector.multiply(-1.0);
                EnemyWave enemyWave = new EnemyWave(deltaE, enemyPos, enemy, bulletVector, time);
                Data.EnemyWaves.add(enemyWave);
                this._router.prepare(Message.Kind.EnemyWaveCreated).at(time).about(enemyWave).send();
            }
        }
        this._router.prepare(Message.Kind.ScannedEnemy).at(time).about(enemy).send();
    }

    public void onBulletHit(BulletHitEvent e) {
        Bullet myBullet = e.getBullet();
        double bulletPower = myBullet.getPower();
        Bot enemy = Data.Robots.Enemy(e.getName());
        Bot self = Data.Robots.Self;
        double bulletDamage = Rules.getBulletDamage((double)bulletPower);
        enemy.Set(Stat.DAMAGE_RECEIVED_THIS_TURN, bulletDamage);
        enemy.Add(Stat.DAMAGE_RECEIVED, Rules.getBulletDamage((double)bulletPower));
        self.Add(Stat.ENERGY_RETURNED, Rules.getBulletHitBonus((double)bulletPower));
        self.Add(Stat.SHOTS_LANDED, 1.0);
        SelfWave foundWave = Data.MyWaves.bySelfBullet(myBullet);
        if (foundWave != null) {
            this._router.prepare(Message.Kind.SelfWaveNeutralized).about(foundWave).at(e.getTime()).send();
        } else {
            System.out.println("WARNING: hit enemy but couldn't find own wave");
        }
        this._router.prepare(Message.Kind.DamagedEnemy).at(e.getTime()).about(enemy).set("Damage", bulletDamage).send();
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Bullet enemyBullet = e.getHitBullet();
        long time = e.getTime();
        Bot self = Data.Robots.Self;
        Bot enemy = Data.Robots.Enemy(enemyBullet.getName());
        enemy.Add(Stat.DAMAGE_SHIELDED, Rules.getBulletDamage((double)e.getBullet().getPower()));
        self.Add(Stat.DAMAGE_SHIELDED, Rules.getBulletDamage((double)enemyBullet.getPower()));
        Bullet myBullet = e.getBullet();
        SelfWave foundSelfWave = Data.MyWaves.bySelfBullet(myBullet);
        if (foundSelfWave != null) {
            this._router.prepare(Message.Kind.SelfWaveNeutralized).about(foundSelfWave).at(time).send();
        } else {
            System.out.println("WARNING: hit enemy bullet but couldn't find own wave");
        }
        EnemyWave foundEnemyWave = Data.EnemyWaves.byEnemyBulletCollision(enemyBullet);
        if (foundEnemyWave != null) {
            this._router.prepare(Message.Kind.EnemyWaveNeutralized).about(foundEnemyWave).at(time).send();
        } else {
            System.out.println("WARNING: hit enemy bullet but couldn't find enemy wave");
        }
        this._router.prepare(Message.Kind.BulletCollision).at(e.getTime()).about(enemy).set("MyBullet", myBullet).set("EnemyBullet", enemyBullet).send();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        Bullet enemyBullet = e.getBullet();
        Bot enemy = Data.Robots.Enemy(e.getName());
        double bulletPower = enemyBullet.getPower();
        double damage = Rules.getBulletDamage((double)bulletPower);
        Bot self = Data.Robots.Self;
        self.Add(Stat.DAMAGE_RECEIVED, damage);
        enemy.Add(Stat.ENERGY_RETURNED, Rules.getBulletHitBonus((double)bulletPower));
        enemy.Set(Stat.ENERGY_RETURNED_THIS_TURN, Rules.getBulletHitBonus((double)bulletPower));
        enemy.Add(Stat.SHOTS_LANDED, 1.0);
        EnemyWave foundWave = Data.EnemyWaves.byEnemyBullet(enemyBullet);
        if (foundWave != null) {
            this._router.prepare(Message.Kind.EnemyWaveNeutralized).about(foundWave).at(e.getTime()).send();
        } else {
            System.out.println("WARNING: hit by bullet but couldn't find enemy wave");
        }
        this._router.prepare(Message.Kind.TookDamage).at(e.getTime()).about(enemy).set("Damage", damage).send();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Bot enemy = Data.Robots.Enemy(e.getName());
        enemy.Alive = false;
        this._router.prepare(Message.Kind.EnemyDestroyed).at(e.getTime()).about(enemy).send();
    }

    public void onWin(WinEvent e) {
        this._router.prepare(Message.Kind.Win).at(e.getTime()).send();
    }

    public void onBattleEnded(BattleEndedEvent event) {
        this._router.prepare(Message.Kind.BattleEnded).at(event.getTime()).set("Results", event.getResults()).send();
    }

    public void onRoundEnded(RoundEndedEvent event) {
        this._router.prepare(Message.Kind.RoundEnded).at(event.getTime()).set("Round", event.getRound()).set("TotalTurns", event.getTotalTurns()).send();
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        System.out.println("WARNING: Turn skipped at: " + e.getTime());
    }

    public void onDeath(DeathEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
        Bot self = Data.Robots.Self;
        Bot enemy = Data.Robots.Enemy(e.getName());
        self.Add(Stat.DAMAGE_RECEIVED, 0.6);
        enemy.Add(Stat.DAMAGE_RECEIVED, 0.6);
        this._router.prepare(Message.Kind.RobotCollision).about(enemy).at(e.getTime()).send();
    }

    public void onHitWall(HitWallEvent e) {
        this._router.prepare(Message.Kind.WallCollision).at(Data.Battle.Time).send();
    }

    public void onCustomEvent(CustomEvent arg0) {
    }

    private void UpdateRelativePositionalStats(Bot bot, Bot otherBot, double x, double y, double absoluteBearing, double heading, double distance, Vect2d headingVector) {
        double myX = bot.Position.getX();
        double myY = bot.Position.getY();
        otherBot.Set(Stat.DISTANCE, distance);
        otherBot.Set(Stat.ABSOLUTEBEARING, absoluteBearing);
        Vect2d vector = headingVector.copy();
        Point2D.Double frontWallPoint = Maths.GetDirectionalWallIntersection(x, y, vector);
        double frontWallDistance = frontWallPoint.distance(x, y);
        otherBot.Set(Stat.WALL_DISTANCE_FRONT, frontWallDistance);
        otherBot.Set(Stat.WALL_DISTANCE_FRONT_THETA, Fath.atan(frontWallDistance / Math.min(distance, frontWallPoint.distance(myX, myY))));
        vector.multiply(-1.0);
        Point2D.Double rearWallPoint = Maths.GetDirectionalWallIntersection(x, y, vector);
        double rearWallDistance = rearWallPoint.distance(x, y);
        otherBot.Set(Stat.WALL_DISTANCE_REAR, rearWallDistance);
        otherBot.Set(Stat.WALL_DISTANCE_REAR_THETA, Fath.atan(rearWallDistance / Math.min(distance, rearWallPoint.distance(myX, myY))));
        Vect2d relativeVector = Vect2d.fromPosition(bot.Position, otherBot.Position);
        relativeVector.unitize();
        double lateralVelocity = relativeVector.cross(otherBot.Velocity);
        double previousLateralVelocity = otherBot.Get(Stat.LATERAL_VELOCITY);
        double lateralAcceleration = lateralVelocity - previousLateralVelocity;
        otherBot.Set(Stat.LATERAL_VELOCITY, lateralVelocity);
        otherBot.Set(Stat.LATERAL_ACCELERATION, lateralAcceleration);
        double approachVelocity = -relativeVector.dot(otherBot.Velocity);
        double previousApproachVelocity = otherBot.Get(Stat.APPROACH_VELOCITY);
        double approachAcceleration = approachVelocity - previousApproachVelocity;
        otherBot.Set(Stat.APPROACH_VELOCITY, approachVelocity);
        otherBot.Set(Stat.APPROACH_ACCELERATION, approachAcceleration);
        double xMod = (double)((absoluteBearing >= Math.PI ? absoluteBearing - Math.PI : absoluteBearing) < 1.5707963267948966 ? -1 : 1) * Data.Battle.HalfRobotWidth;
        double d1 = Point2D.Double.distance(myX, myY, x + xMod, y + Data.Battle.HalfRobotWidth);
        double d2 = Point2D.Double.distance(myX, myY, x - xMod, y - Data.Battle.HalfRobotWidth);
        double radarCrossSection = Fath.atan(Data.Battle.MaxRobotWidth / Math.min(d1, d2));
        otherBot.Set(Stat.RADAR_CROSSSECTION, radarCrossSection);
    }

    private void UpdatePositionalStats(Bot bot, double x, double y) {
        bot.Position.setLocation(x, y);
        bot.HitBox.Move(bot.Position);
        double cornerX = x >= Data.Battle.BattleFieldWidth / 2.0 ? Data.Battle.BattleFieldWidth - Data.Battle.HalfRobotWidth : Data.Battle.HalfRobotWidth;
        double cornerY = y >= Data.Battle.BattleFieldHeight / 2.0 ? Data.Battle.BattleFieldHeight - Data.Battle.HalfRobotWidth : Data.Battle.HalfRobotWidth;
        bot.Set(Stat.CORNER_PROXIMITY, Point2D.Double.distance(x, y, cornerX, cornerY));
        double wallX = x >= Data.Battle.BattleFieldWidth / 2.0 ? Data.Battle.BattleFieldWidth - x : x;
        double wallY = y >= Data.Battle.BattleFieldHeight / 2.0 ? Data.Battle.BattleFieldHeight - y : y;
        bot.Set(Stat.WALL_PROXIMITY, Maths.Round(Math.min(wallX, wallY) - Data.Battle.HalfRobotWidth));
    }

    private void UpdateHeadingStats(Bot bot, double heading, double time) {
        double headingAlpha;
        double previousHeading = bot.Get(Stat.HEADING);
        double previousHeadingOmega = bot.Get(Stat.HEADING_OMEGA);
        double headingOmega = Maths.normalRelativeAngle(heading - previousHeading);
        if (headingOmega < 0.0) {
            headingOmega += Math.PI * 2;
        }
        if ((headingAlpha = Maths.normalRelativeAngle(headingOmega - previousHeadingOmega)) < 0.0) {
            headingAlpha += Math.PI * 2;
        }
        bot.Set(Stat.HEADING, heading);
        bot.Set(Stat.HEADING_OMEGA, headingOmega);
        bot.Set(Stat.HEADING_ALPHA, headingAlpha);
    }

    private void UpdateVelocityStats(Bot bot, double rawVelocity, Vect2d heading) {
        double previousVelocity = bot.Get(Stat.VELOCITY);
        double previousAcceleration = bot.Get(Stat.ACCELERATION);
        double acceleration = rawVelocity - previousVelocity;
        double jerk = acceleration - previousAcceleration;
        bot.Set(Stat.VELOCITY, rawVelocity);
        bot.Set(Stat.ACCELERATION, acceleration);
        bot.Set(Stat.JERK, jerk);
        bot.Heading = heading;
        bot.Velocity = Vect2d.multiply(heading, rawVelocity);
        bot.Add(Stat.DISTANCE_TRAVELED, Math.abs(rawVelocity));
    }
}

