/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java8.util.function.Consumer;

public final class MessageRouter {
    private HashMap<Message.Kind, ArrayList<Consumer<Message>>> _handlers = new HashMap();
    private static ArrayList<Message> _messages = new ArrayList();

    public void Subscribe(Message.Kind type, Consumer<Message> handler) {
        ArrayList<Consumer<Message>> typeList = this._handlers.get((Object)type);
        if (typeList == null) {
            typeList = new ArrayList();
            this._handlers.put(type, typeList);
        }
        typeList.add(handler);
    }

    public void Unsubscribe(Message.Kind type, Consumer<Message> handler) {
        ArrayList<Consumer<Message>> typeList = this._handlers.get((Object)type);
        if (typeList != null) {
            typeList.remove(handler);
        }
    }

    public void Send(Message message) {
        ArrayList<Consumer<Message>> typeList = this._handlers.get((Object)message.type);
        if (typeList != null) {
            for (Consumer<Message> handler : typeList) {
                handler.accept(message);
            }
            if (typeList.size() == 0) {
                System.out.println("WARNING: event type " + message.type.toString() + " has no recipients.");
            }
        }
        message.Reset();
    }

    public void reset() {
        for (Message message : _messages) {
            if (message.type == Message.Kind.None) continue;
            System.out.println("WARNING: event type " + message.type.toString() + " persisted after turn end.");
            message.Reset();
        }
    }

    public Message prepare(Message.Kind type) {
        Message retval = null;
        for (Message message : _messages) {
            if (message.type != Message.Kind.None) continue;
            retval = message;
            break;
        }
        if (retval == null) {
            retval = new Message();
            _messages.add(retval);
        }
        retval.setRouter(this);
        retval.type = type;
        return retval;
    }
}

