/*
 * Decompiled with CFR 0.152.
 */
package bigpete;

import bigpete.CustFunct;
import java.awt.geom.Point2D;

public class PointPolar {
    double angle;
    double magnitude;

    PointPolar() {
    }

    public void add(PointPolar input) {
        if (input.getMagnitude() == 0.0) {
            return;
        }
        double x = input.getMagnitude() * Math.cos(input.getAngle()) + this.magnitude * Math.cos(this.angle);
        double y = input.getMagnitude() * Math.sin(input.getAngle()) + this.magnitude * Math.sin(this.angle);
        this.angle = Math.atan2(y, x);
        this.magnitude = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, x));
    }

    public void vectorToPolar(Point2D force) {
        this.vectorToPolar(force.getX(), force.getY());
    }

    public void vectorToPolar(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            this.setLocation(0.0, 0.0);
        }
        double angle = Math.abs(Math.atan(x / y));
        if (y < 0.0) {
            angle = Math.PI - angle;
        }
        if (x < 0.0) {
            angle = -angle;
        }
        angle = CustFunct.normaliseAbsolute(angle);
        double force = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0)) * 10000.0;
        this.setLocation(angle, force);
    }

    public void setLocation(double angle_in, double magnitude_in) {
        this.angle = angle_in;
        this.magnitude = magnitude_in;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double input) {
        this.angle = input;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double input) {
        this.magnitude = input;
    }
}

