/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.DivineBot;
import divineomega.GFTUtils;
import java.awt.geom.Point2D;
import java.util.HashMap;
import robocode.Condition;
import robocode.util.Utils;

public class GFTWave
extends Condition {
    public static Point2D targetLocation;
    public double bulletPower;
    public Point2D gunLocation;
    public double bearing;
    public double lateralDirection;
    private static final double MAX_DISTANCE = 900.0;
    private static final int DISTANCE_INDEXES = 5;
    private static final int VELOCITY_INDEXES = 5;
    private static final int NEAR_WALL_INDEXES = 3;
    private static final int BINS = 25;
    private static final int MIDDLE_BIN = 12;
    private static final double MAX_ESCAPE_ANGLE = 0.7;
    private static final double BIN_WIDTH = 0.05833333333333333;
    private static int nearWallIndex;
    private static int velocityIndex;
    private static int lastVelocityIndex;
    private static int distanceIndex;
    private static String enemyName;
    public static HashMap<String, double[][][][][]> enemyNameToStatBuffer;
    private double[] buffer;
    private double distanceTraveled;
    private DivineBot robot;

    static {
        enemyNameToStatBuffer = new HashMap();
    }

    public GFTWave(DivineBot robot) {
        this.robot = robot;
    }

    public boolean test() {
        this.advance();
        if (this.hasArrived()) {
            int index = this.currentBin();
            int x = 0;
            while (x < 25) {
                int n = x;
                this.buffer[n] = this.buffer[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
                ++x;
            }
            double[][][][][] statBuffers = enemyNameToStatBuffer.get(enemyName);
            if (statBuffers == null) {
                statBuffers = new double[3][5][5][5][25];
            }
            statBuffers[GFTWave.nearWallIndex][GFTWave.distanceIndex][GFTWave.velocityIndex][GFTWave.lastVelocityIndex] = this.buffer;
            enemyNameToStatBuffer.put(enemyName, statBuffers);
            this.robot.removeCustomEvent(this);
        }
        return false;
    }

    public double mostVisitedBearingOffset() {
        return this.lateralDirection * 0.05833333333333333 * (double)(this.mostVisitedBin() - 12);
    }

    public void setSegmentations(String enemyName, double distance, double velocity, double lastVelocity) {
        distanceIndex = Math.min(4, (int)(distance / 180.0));
        velocityIndex = (int)Math.abs(velocity / 2.0);
        lastVelocityIndex = (int)Math.abs(lastVelocity / 2.0);
        nearWallIndex = 0;
        int nearWallMargin = 50;
        if (targetLocation.getX() < (double)nearWallMargin && targetLocation.getY() < (double)nearWallMargin) {
            nearWallIndex = 2;
        } else if (targetLocation.getX() > DivineBot.battleFieldWidth - (double)nearWallMargin && targetLocation.getY() > DivineBot.battleFieldHeight - (double)nearWallMargin) {
            nearWallIndex = 2;
        } else if (targetLocation.getX() < (double)nearWallMargin && targetLocation.getY() > DivineBot.battleFieldHeight - (double)nearWallMargin) {
            nearWallIndex = 2;
        } else if (targetLocation.getX() > DivineBot.battleFieldWidth - (double)nearWallMargin && targetLocation.getY() < (double)nearWallMargin) {
            nearWallIndex = 2;
        } else if (targetLocation.getX() < (double)nearWallMargin || targetLocation.getY() < (double)nearWallMargin || targetLocation.getX() > DivineBot.battleFieldWidth - (double)nearWallMargin || targetLocation.getY() > DivineBot.battleFieldHeight - (double)nearWallMargin) {
            nearWallIndex = 1;
        }
        GFTWave.enemyName = enemyName;
        double[][][][][] statBuffers = enemyNameToStatBuffer.get(enemyName);
        if (statBuffers == null) {
            statBuffers = new double[3][5][5][5][25];
        }
        this.buffer = statBuffers[nearWallIndex][distanceIndex][velocityIndex][lastVelocityIndex];
    }

    private void advance() {
        this.distanceTraveled += GFTUtils.bulletVelocity(this.bulletPower);
    }

    private boolean hasArrived() {
        return this.distanceTraveled > this.gunLocation.distance(targetLocation) - 18.0;
    }

    private int currentBin() {
        int bin = (int)Math.round(Utils.normalRelativeAngle((double)(GFTUtils.absoluteBearing(this.gunLocation, targetLocation) - this.bearing)) / (this.lateralDirection * 0.05833333333333333) + 12.0);
        return GFTUtils.minMax(bin, 0, 24);
    }

    private int mostVisitedBin() {
        int mostVisited = 12;
        int i = 0;
        while (i < 25) {
            if (this.buffer[i] > this.buffer[mostVisited]) {
                mostVisited = i;
            }
            ++i;
        }
        return mostVisited;
    }
}

