/*
 * Decompiled with CFR 0.152.
 */
package co.edu.usb.rc;

import co.edu.usb.rc.GravPoint;
import co.edu.usb.rc.Trigonometry;
import java.awt.geom.Point2D;
import java.util.Vector;

public class AGravEngine {
    protected Vector<GravPoint> gravPoints = new Vector();
    protected double wallForce = 0.0;
    protected double width;
    protected double height;
    protected double xForce = 0.0;
    protected double yForce = 0.0;
    protected double pointDropoff = 2.0;
    protected double wallDropoff = 3.0;

    public AGravEngine() {
        this(0.0, 0.0);
    }

    public AGravEngine(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void addPoint(GravPoint g) {
        this.gravPoints.add(g);
    }

    public boolean removePoint(GravPoint g) {
        return this.gravPoints.remove(g);
    }

    public long getNumPoints() {
        return this.gravPoints.size();
    }

    public double getWallForce() {
        return this.wallForce;
    }

    public void setWallForce(double wf) {
        this.wallForce = wf;
    }

    public double getPointDropoff() {
        return this.pointDropoff;
    }

    public void setPointDropoff(double pdf) {
        this.pointDropoff = pdf;
    }

    public double getWallDropoff() {
        return this.wallDropoff;
    }

    public void setWallDropoff(double wdf) {
        this.wallDropoff = wdf;
    }

    public void reset() {
        this.gravPoints = new Vector();
    }

    public void update(double curX, double curY, long time) {
        this.xForce = 0.0;
        this.yForce = 0.0;
        Vector<GravPoint> deadPoints = new Vector<GravPoint>();
        int i = 0;
        while (i < this.gravPoints.size()) {
            GravPoint g = this.gravPoints.elementAt(i);
            if (g.update(time)) {
                deadPoints.add(g);
            } else {
                double force = g.strength / Math.pow(Point2D.distance(curX, curY, g.x, g.y), this.pointDropoff);
                double angle = Trigonometry.getBearing(curX, curY, g.x, g.y);
                this.xForce += force * Math.sin(angle);
                this.yForce += force * Math.cos(angle);
            }
            ++i;
        }
        this.xForce += this.wallForce / Math.pow(curX, this.wallDropoff);
        this.xForce -= this.wallForce / Math.pow(this.width - curX, this.wallDropoff);
        this.yForce -= this.wallForce / Math.pow(this.height - curY, this.wallDropoff);
        this.yForce += this.wallForce / Math.pow(curY, this.wallDropoff);
        i = 0;
        while (i < deadPoints.size()) {
            this.gravPoints.remove(deadPoints.elementAt(i));
            ++i;
        }
    }

    public double getXForce() {
        return this.xForce;
    }

    public double getYForce() {
        return this.yForce;
    }

    public String toString() {
        String string = "Points:" + this.gravPoints;
        return string;
    }
}

