/*
 * Decompiled with CFR 0.152.
 */
package bh.components.history;

import bh.components.history.Merge;
import bh.components.history.RobotDelta;
import bh.units.Angle;
import bh.units.Bearing;
import bh.units.Distance;
import bh.units.Energy;
import bh.units.Heading;
import bh.units.Heat;
import bh.units.Location;
import bh.units.RelativeLocation;
import bh.units.Speed;
import bh.units.Units;
import bh.units.Velocity;
import bh.units.interfaces.AbsoluteToRelative;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RobotState
implements AbsoluteToRelative<RobotState, RobotDelta> {
    private final Energy energy;
    private final Location location;
    private final Heading heading;
    private final Speed speed;
    private final Heading gunHeading;
    private final Heat gunHeat;
    private final Heading radarHeading;

    RobotState(Energy energy, Location location, Heading heading, Speed speed, Heading gunHeading, Heat gunHeat, Heading radarHeading) {
        this.energy = energy;
        this.location = location;
        this.heading = heading;
        this.speed = speed;
        this.gunHeading = gunHeading;
        this.gunHeat = gunHeat;
        this.radarHeading = radarHeading;
    }

    public Energy energy() {
        return this.energy;
    }

    public Location location() {
        return this.location;
    }

    public Heading heading() {
        return this.heading;
    }

    public Speed speed() {
        return this.speed;
    }

    public Velocity velocity() {
        if (this.heading == null || this.speed == null) {
            return null;
        }
        return new Velocity(this.heading, this.speed);
    }

    public Heading gunHeading() {
        return this.gunHeading;
    }

    public Heat gunHeat() {
        return this.gunHeat;
    }

    public Heading radarHeading() {
        return this.radarHeading;
    }

    boolean empty() {
        return this.energy() == null && this.location() == null && this.heading() == null && this.speed() == null && this.gunHeading() == null && this.gunHeat() == null && this.radarHeading() == null;
    }

    public RobotState conflicts(RobotState rs) {
        if (rs == null) {
            return null;
        }
        RobotState conflicts = new Builder().energy(Merge.valueConflict(this.energy(), rs.energy())).location(Merge.valueConflict(this.location(), rs.location())).heading(Merge.valueConflict(this.heading(), rs.heading())).speed(Merge.valueConflict(this.speed(), rs.speed())).gunHeading(Merge.valueConflict(this.gunHeading(), rs.gunHeading())).gunHeat(Merge.valueConflict(this.gunHeat(), rs.gunHeat())).radarHeading(Merge.valueConflict(this.radarHeading(), rs.radarHeading())).build();
        if (conflicts.empty()) {
            return null;
        }
        return conflicts;
    }

    public RobotState merge(RobotState rs) {
        if (rs == null) {
            return this;
        }
        return new Builder().energy(Merge.valueMerge(this.energy(), rs.energy())).location(Merge.valueMerge(this.location(), rs.location())).heading(Merge.valueMerge(this.heading(), rs.heading())).speed(Merge.valueMerge(this.speed(), rs.speed())).gunHeading(Merge.valueMerge(this.gunHeading(), rs.gunHeading())).gunHeat(Merge.valueMerge(this.gunHeat(), rs.gunHeat())).radarHeading(Merge.valueMerge(this.radarHeading(), rs.radarHeading())).build();
    }

    @Override
    public RobotDelta minus(RobotState rs) {
        return new RobotDelta.Builder().energyDelta((Energy)Units.minusWithNulls(this.energy(), rs.energy())).locationDelta((RelativeLocation)Units.minusWithNulls(this.location(), rs.location())).headingDelta((Bearing)Units.minusWithNulls(this.heading(), rs.heading())).speedDelta((Speed)Units.minusWithNulls(this.speed(), rs.speed())).gunHeadingDelta((Bearing)Units.minusWithNulls(this.gunHeading(), rs.gunHeading())).gunHeatDelta((Heat)Units.minusWithNulls(this.gunHeat(), rs.gunHeat())).radarHeadingDelta((Bearing)Units.minusWithNulls(this.radarHeading(), rs.radarHeading())).build();
    }

    @Override
    public RobotState plus(RobotDelta rd) {
        return new Builder().energy(Units.plusWithNulls(this.energy(), rd.energyDelta())).location(Units.plusWithNulls(this.location(), rd.locationDelta())).heading(Units.plusWithNulls(this.heading(), rd.headingDelta())).speed(Units.plusWithNulls(this.speed(), rd.speedDelta())).gunHeading(Units.plusWithNulls(this.gunHeading(), rd.gunHeadingDelta())).gunHeat(Units.plusWithNulls(this.gunHeat(), rd.gunHeatDelta())).radarHeading(Units.plusWithNulls(this.radarHeading(), rd.radarHeadingDelta())).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-<BOT>-");
        if (this.energy != null) {
            sb.append(" nrg(").append(this.energy).append(")");
        }
        if (this.location != null) {
            sb.append(" loc").append(this.location.toString());
        }
        if (this.heading != null) {
            sb.append(" hdg(").append(this.heading).append(")");
        }
        if (this.speed != null) {
            sb.append(" spd(").append(this.speed).append(")");
        }
        sb.append(" -<GUN>-");
        if (this.gunHeading != null) {
            sb.append(" hdg(").append(this.gunHeading).append(")");
        }
        if (this.gunHeat != null) {
            sb.append(" ht(").append(this.gunHeat).append(")");
        }
        sb.append(" -<RADAR>-");
        if (this.radarHeading != null) {
            sb.append(" hdg(").append(this.radarHeading).append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RobotState)) {
            return false;
        }
        RobotState rs = (RobotState)o;
        boolean bl = this.energy() == null ? rs.energy() == null : (result = this.energy().equals(rs.energy()));
        boolean bl2 = result && (this.location() == null ? rs.location() == null : this.location().equals(rs.location())) ? true : (result = false);
        boolean bl3 = result && (this.heading() == null ? rs.heading() == null : this.heading().equals(rs.heading())) ? true : (result = false);
        boolean bl4 = result && (this.speed() == null ? rs.speed() == null : this.speed().equals(rs.speed())) ? true : (result = false);
        boolean bl5 = result && (this.gunHeading() == null ? rs.gunHeading() == null : this.gunHeading().equals(rs.gunHeading())) ? true : (result = false);
        boolean bl6 = result && (this.gunHeat() == null ? rs.gunHeat() == null : this.gunHeat().equals(rs.gunHeat())) ? true : (result = false);
        result = result && (this.radarHeading() == null ? rs.radarHeading() == null : this.radarHeading().equals(rs.radarHeading()));
        return result;
    }

    public int hashCode() {
        int hc = this.energy() == null ? 0 : this.energy().hashCode();
        hc = hc * 31 + (this.location() == null ? 0 : this.location().hashCode());
        hc = hc * 31 + (this.heading() == null ? 0 : this.heading().hashCode());
        hc = hc * 31 + (this.speed() == null ? 0 : this.speed().hashCode());
        hc = hc * 31 + (this.gunHeading() == null ? 0 : this.gunHeading().hashCode());
        hc = hc * 31 + (this.gunHeat() == null ? 0 : this.gunHeat().hashCode());
        hc = hc * 31 + (this.radarHeading() == null ? 0 : this.radarHeading().hashCode());
        return hc;
    }

    public static class Builder {
        public Energy energy = null;
        public Location location = null;
        public Heading heading = null;
        public Speed speed = null;
        public Heading gunHeading = null;
        public Heat gunHeat = null;
        public Heading radarHeading = null;

        public Builder energy(Energy energy) {
            this.energy = energy;
            return this;
        }

        public Builder energy(double energy) {
            return this.energy(new Energy(energy));
        }

        public Builder location(Location location) {
            this.location = location;
            return this;
        }

        public Builder location(double x, double y) {
            return this.location(new Location(new Distance(x), new Distance(y)));
        }

        public Builder heading(Heading heading) {
            this.heading = heading;
            return this;
        }

        public Builder heading(double heading) {
            return this.heading(new Heading(Angle.fromDegrees(heading)));
        }

        public Builder speed(Speed speed) {
            this.speed = speed;
            return this;
        }

        public Builder speed(double speed) {
            return this.speed(new Speed(speed));
        }

        public Builder gunHeading(Heading gunHeading) {
            this.gunHeading = gunHeading;
            return this;
        }

        public Builder gunHeading(double gunHeading) {
            return this.gunHeading(new Heading(Angle.fromDegrees(gunHeading)));
        }

        public Builder gunHeat(Heat gunHeat) {
            this.gunHeat = gunHeat;
            return this;
        }

        public Builder gunHeat(double gunHeat) {
            return this.gunHeat(new Heat(gunHeat));
        }

        public Builder radarHeading(Heading radarHeading) {
            this.radarHeading = radarHeading;
            return this;
        }

        public Builder radarHeading(double radarHeading) {
            return this.radarHeading(new Heading(Angle.fromDegrees(radarHeading)));
        }

        public RobotState build() {
            return new RobotState(this.energy, this.location, this.heading, this.speed, this.gunHeading, this.gunHeat, this.radarHeading);
        }
    }
}

