/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Distance;
import bh.units.Duration;
import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Speed
implements Continuum<Speed>,
AbsoluteToRelative<Speed, Speed> {
    private final double pixelsPerTurn;

    public Speed(double pixelsPerTurn) {
        assert (!Double.isNaN(pixelsPerTurn));
        this.pixelsPerTurn = (double)Math.round(pixelsPerTurn * 1000000.0) / 1000000.0;
    }

    @Override
    public Speed negate() {
        return new Speed(-this.pixelsPerTurn);
    }

    @Override
    public Speed abs() {
        return new Speed(Math.abs(this.pixelsPerTurn));
    }

    @Override
    public Speed plus(Speed d) {
        return new Speed(this.pixelsPerTurn + d.pixelsPerTurn);
    }

    @Override
    public Speed minus(Speed d) {
        return new Speed(this.pixelsPerTurn - d.pixelsPerTurn);
    }

    @Override
    public Speed times(double d) {
        return new Speed(this.pixelsPerTurn * d);
    }

    public Distance times(Duration duration) {
        return new Distance(this.pixelsPerTurn * duration.toDouble());
    }

    @Override
    public Speed divide(double d) {
        return new Speed(this.pixelsPerTurn / d);
    }

    @Override
    public double divide(Speed speed) {
        return this.pixelsPerTurn / speed.pixelsPerTurn;
    }

    @Override
    public double toDouble() {
        return this.pixelsPerTurn;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.pixelsPerTurn)) + "ppt";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Speed)) {
            return false;
        }
        Speed speed = (Speed)o;
        return speed.pixelsPerTurn == this.pixelsPerTurn;
    }

    public int hashCode() {
        return new Double(this.pixelsPerTurn).hashCode();
    }
}

