/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.data;

import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import vuen.fractal.FractalE;
import vuen.fractal.data.Gen;
import vuen.fractal.data.Packet;
import vuen.fractal.data.Score;

public class Memory {
    public Packet[][] data;
    public String[] name;
    public Gen gen;
    public Score score;
    public int totalbots;
    int datasize;
    FractalE robot;

    public Memory(FractalE robot) {
        this.robot = robot;
        this.datasize = 10000;
        this.totalbots = robot.getOthers();
        this.name = new String[this.totalbots + 1];
        this.gen = new Gen(robot, this);
        this.score = new Score(robot, this);
        int junk = this.getNameIndex(robot.getName());
        this.data = new Packet[this.totalbots + 1][this.datasize];
    }

    public void init() {
        for (int i = 0; i <= this.totalbots; ++i) {
            for (int i2 = 0; i2 < this.datasize; ++i2) {
                this.data[i][i2] = null;
            }
        }
        this.gen.init();
        this.score.init();
    }

    public void go() {
        Packet me = new Packet();
        me.x = this.robot.getX();
        me.y = this.robot.getY();
        me.heading = this.robot.getHeading();
        me.velocity = this.robot.getVelocity();
        me.energy = this.robot.getEnergy();
        me.reliability = 1.0;
        this.data[0][(int)this.robot.getTime() + 1] = me;
        this.gen.go();
    }

    public void processScan(ScannedRobotEvent e) {
        int id = this.getNameIndex(e.getName());
        int time = (int)this.robot.getTime();
        this.data[id][time] = new Packet();
        this.data[id][time].energy = e.getEnergy();
        this.data[id][time].x = this.robot.getX() + e.getDistance() * Math.sin(Math.toRadians(e.getBearing() + this.robot.getHeading()));
        this.data[id][time].y = this.robot.getY() + e.getDistance() * Math.cos(Math.toRadians(e.getBearing() + this.robot.getHeading()));
        this.data[id][time].heading = e.getHeading();
        this.data[id][time].velocity = e.getVelocity();
        this.data[id][time].reliability = 1.0;
    }

    public int getNameIndex(String pname) {
        int i;
        for (i = 0; i <= this.totalbots && this.name[i] != null; ++i) {
            if (!this.name[i].equals(pname)) continue;
            return i;
        }
        this.robot.println("Found (Slot " + i + ") : " + pname);
        this.name[i] = pname;
        return i;
    }

    public void processBulletHit(BulletHitEvent e) {
        this.score.onBulletHit(e);
    }

    public void processHitByBullet(HitByBulletEvent e) {
        this.score.onHitByBullet(e);
    }

    public void processWin(WinEvent e) {
        this.robot.println("I have won!");
        this.score.onWin(e);
        this.score.printScore();
    }

    public void processDeath(DeathEvent e) {
        this.robot.println("I have died!");
        this.score.onDeath(e);
        this.score.printScore();
    }

    public int getTime() {
        return (int)this.robot.getTime();
    }

    public int getTarget() {
        return 1;
    }

    public Packet getPacket(int bot, long time) {
        if (time >= 0L) {
            return this.data[bot][(int)time];
        }
        return null;
    }

    public Packet getPacket(int bot) {
        return this.getPacket(bot, this.getTime());
    }

    public Packet getPacketOffset(int bot, int time) {
        return this.getPacket(bot, (int)this.robot.getTime() + time);
    }
}

