/*
 * Decompiled with CFR 0.152.
 */
package lrem.quickhack;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class QuickHack
extends AdvancedRobot {
    static final int wallMargin = 50;
    static final int cornerRadius = 70;
    static final double slowDownAngle = 0.5235987755982988;
    static final double distanceControlAngle = 0.5235987755982988;
    static final int targetingMethodsCount = 5;
    static final int EDIndexes = 3;
    static final int EEIndexes = 2;
    static final double desiredFirePower = 1.7;
    static final double shortShot = 100.0;
    static final double longShot = 600.0;
    static int[][][] VGStats = new int[2][3][5];
    static final int patternHistoryLength = 2500;
    static final int searchDepth = 75;
    static double[] patternHeadingHistory = new double[2500];
    static double[] patternVelocityHistory = new double[2500];
    static double[] fakeHistory = new double[2500];
    static int patternHistoryEnd = 0;
    static boolean patternHistoryLooped = false;
    static final double maxDistance = 800.0;
    static final int arcTime = 35;
    static final int distanceSegments = 8;
    static boolean musashiTrick = true;
    static long inversionTime;
    static long gravTime;
    static long timeOfPreviousMovementAlgorithmChange;
    static int currentMovement;
    static int[][][] distanceStats;
    static double movementSelectorPower;
    static RoundRectangle2D field;
    static Point2D myDestination;
    static Point2D myPosition;
    static Point2D enemyPosition;
    static double enemyDistance;
    static double absBearing;
    static double enemyVelocity;
    static double enemyPreviousVelocity;
    static double enemyPreviousEnergy;
    static double enemyEnergy;
    static double enemyHeading;
    static double enemyPreviousHeading;
    static double enemyBearing;
    static double randomFactor;
    static double enemyFirePower;
    static double firePower;
    static double myEnergy;
    static long shotTime;
    static int myDirection;
    static int enemyDirection;
    static int currentTargeting;
    static int totalBullets;
    static Random randomizer;
    static String enemyName;

    public void run() {
        field = new RoundRectangle2D.Double(50.0, 50.0, this.getBattleFieldWidth() - 100.0, this.getBattleFieldHeight() - 100.0, 70.0, 70.0);
        myPosition = new Point2D.Double();
        myDestination = new Point2D.Double();
        myDestination.setLocation(this.getX(), this.getY());
        enemyPosition = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        this.setColors(Color.white, Color.yellow, Color.white);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        QuickHack.distanceStats[0][0][1] = 10;
        QuickHack.distanceStats[1][0][0] = 1;
        QuickHack.distanceStats[1][0][1] = 3;
        QuickHack.distanceStats[0][1][1] = 10;
        QuickHack.distanceStats[1][1][0] = 1;
        QuickHack.distanceStats[1][1][1] = 2;
        for (int i = 2; i < 8; ++i) {
            QuickHack.distanceStats[i][0][0] = 1;
            QuickHack.distanceStats[i][0][1] = 1;
            QuickHack.distanceStats[i][1][0] = 1;
            QuickHack.distanceStats[i][1][1] = 1;
        }
        shotTime = 0L;
        this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        if (enemyName == "Sucker") {
            enemyName = scannedRobotEvent.getName();
            this.loadData();
        }
        enemyBearing = scannedRobotEvent.getBearingRadians();
        absBearing = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + enemyBearing));
        myPosition.setLocation(this.getX(), this.getY());
        myEnergy = this.getEnergy();
        enemyDistance = scannedRobotEvent.getDistance();
        enemyPosition.setLocation(myPosition.getX() + Math.sin(absBearing) * enemyDistance, myPosition.getY() + Math.cos(absBearing) * enemyDistance);
        enemyPreviousVelocity = enemyVelocity;
        enemyPreviousEnergy = enemyEnergy;
        enemyEnergy = scannedRobotEvent.getEnergy();
        enemyPreviousHeading = enemyHeading;
        enemyHeading = scannedRobotEvent.getHeadingRadians();
        enemyVelocity = scannedRobotEvent.getVelocity();
        if (0.1 <= enemyPreviousEnergy - enemyEnergy && enemyPreviousEnergy - enemyEnergy <= 3.0) {
            shotTime = this.getTime();
            enemyFirePower = enemyPreviousEnergy - enemyEnergy;
        }
        if (enemyVelocity != 0.0) {
            enemyDirection = Math.sin(scannedRobotEvent.getHeadingRadians() - absBearing) * enemyVelocity < 0.0 ? -1 : 1;
        }
        this.setTurnRadarLeftRadians(this.getRadarTurnRemaining());
        this.doMovement();
        this.goTo();
        this.doTargeting();
        this.execute();
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        if (this.getTime() > 15L && this.getOthers() > 0 && enemyDistance > 150.0 && this.getTime() > gravTime && (double)this.getTime() > (double)inversionTime + enemyDistance / QuickHack.bulletVelocity(enemyFirePower) / 2.0) {
            musashiTrick = false;
            this.out.println("Dropping");
        }
        int[] nArray = distanceStats[this.distanceIndex()][currentMovement];
        nArray[1] = nArray[1] + 1;
        enemyEnergy += 3.0 * hitByBulletEvent.getPower();
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        int[] nArray = distanceStats[this.distanceIndex()][currentMovement];
        nArray[0] = nArray[0] + 1;
        enemyEnergy -= 4.0 * bulletHitEvent.getBullet().getPower();
        if (bulletHitEvent.getBullet().getPower() > 1.0) {
            enemyEnergy -= 2.0 * bulletHitEvent.getBullet().getPower() - 2.0;
        }
    }

    public void onDeath(DeathEvent deathEvent) {
        this.saveData();
    }

    public void onWin(WinEvent winEvent) {
        this.saveData();
    }

    void doTargeting() {
        double[] dArray = new double[5];
        int[] nArray = VGStats[this.EEI()][this.EDI()];
        this.patternRecord();
        firePower = enemyDistance < 100.0 ? 3.0 : (enemyDistance > 600.0 ? 0.6 : 1.7);
        firePower = Math.min(Math.min(enemyEnergy / 4.0, myEnergy / 5.0), firePower);
        if (this.getGunHeat() > 0.6) {
            for (int i = 0; i < 5; ++i) {
                if (nArray[i] <= nArray[currentTargeting]) continue;
                currentTargeting = i;
            }
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.HOTGuess() - this.getGunHeadingRadians())));
        } else {
            dArray[0] = this.CTGuess();
            dArray[1] = this.RTGuess();
            dArray[2] = this.HOTGuess();
            dArray[3] = this.SPMGuess();
            dArray[4] = this.FPMGuess();
            this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(dArray[currentTargeting] - this.getGunHeadingRadians())));
        }
        if (this.getGunHeat() == 0.0) {
            virtualGunWave virtualGunWave2 = new virtualGunWave();
            virtualGunWave2.firePosition.setLocation(myPosition);
            virtualGunWave2.bulletVelocity = QuickHack.bulletVelocity(firePower);
            for (int i = 0; i < 5; ++i) {
                virtualGunWave2.guesses[i] = dArray[i];
            }
            virtualGunWave2.stats = nArray;
            this.addCustomEvent(virtualGunWave2);
            randomFactor = randomizer.nextDouble() * 0.8 + 0.2;
            if (myEnergy > 0.0) {
                this.setFire(firePower);
            }
        }
    }

    void doMovement() {
        if (!musashiTrick) {
            if (timeOfPreviousMovementAlgorithmChange + 50L < this.getTime() && (double)distanceStats[this.distanceIndex()][currentMovement][0] / Math.pow(distanceStats[this.distanceIndex()][currentMovement][1], movementSelectorPower) < (double)distanceStats[this.distanceIndex()][(currentMovement + 1) % 2][0] / Math.pow(distanceStats[this.distanceIndex()][(currentMovement + 1) % 2][1], movementSelectorPower)) {
                currentMovement = (currentMovement + 1) % 2;
            }
            if (enemyDistance < 200.0) {
                currentMovement = 0;
            }
            if (currentMovement == 0 && this.getTime() > inversionTime) {
                if (randomizer.nextDouble() < 0.7) {
                    myDirection *= -1;
                }
                inversionTime = this.getTime() + (long)randomizer.nextInt((int)(enemyDistance / QuickHack.bulletVelocity(enemyFirePower)));
            }
        }
        if (!this.smoothe()) {
            myDirection *= -1;
            inversionTime = this.getTime() + (long)randomizer.nextInt(35);
            if (!this.smoothe()) {
                gravTime = this.getTime() + 10L;
                this.antiGravity();
            }
        }
        if (!musashiTrick && currentMovement == 1 && shotTime + 7L < this.getTime()) {
            this.setMaxVelocity(0.0);
        } else {
            this.setMaxVelocity(8.0);
        }
    }

    static Point2D vectorToLocation(double d, double d2, Point2D point2D) {
        return new Point2D.Double(point2D.getX() + Math.sin(d) * d2, point2D.getY() + Math.cos(d) * d2);
    }

    boolean smoothe() {
        int n = 0;
        double d = enemyDistance * 1.005;
        if (this.distanceIndex() + 1 < 8 && (double)distanceStats[this.distanceIndex()][currentMovement][0] / Math.pow(distanceStats[this.distanceIndex()][currentMovement][1], movementSelectorPower) < (double)distanceStats[this.distanceIndex() + 1][currentMovement][0] / Math.pow(distanceStats[this.distanceIndex() + 1][currentMovement][1], movementSelectorPower)) {
            d *= 1.16;
        } else if (1 < this.distanceIndex() - 1 && (double)distanceStats[this.distanceIndex()][currentMovement][0] / Math.pow(distanceStats[this.distanceIndex()][currentMovement][1], movementSelectorPower) < (double)distanceStats[this.distanceIndex() - 1][currentMovement][0] / Math.pow(distanceStats[this.distanceIndex() - 1][currentMovement][1], movementSelectorPower)) {
            d *= 0.85;
        }
        if (enemyDistance < 200.0) {
            d = enemyDistance * 1.2;
        }
        double d2 = d;
        do {
            myDestination = QuickHack.vectorToLocation(QuickHack.absoluteBearing(enemyPosition, myPosition) + (double)myDirection * 0.2, d, enemyPosition);
            d *= 0.995;
        } while (++n < 150 && !field.contains(myDestination));
        return field.contains(myDestination) && d > 150.0;
    }

    void antiGravity() {
        double d = 1000000.0 / Math.pow(myPosition.distance(enemyPosition), 2.0);
        myDestination.setLocation(myPosition.getX() - d * Math.sin(absBearing), myPosition.getY() - d * Math.cos(absBearing));
        myDestination.setLocation(myDestination.getX() + 1.0E7 / Math.pow(myPosition.getX(), 2.5), myDestination.getY() + 1.0E7 / Math.pow(myPosition.getY(), 2.5));
        myDestination.setLocation(myDestination.getX() - 1.0E7 / Math.pow(this.getBattleFieldWidth() - myPosition.getX(), 2.5), myDestination.getY() - 1.0E7 / Math.pow(this.getBattleFieldHeight() - myPosition.getY(), 2.5));
    }

    double CTGuess() {
        Point2D point2D = new Point2D.Double(enemyPosition.getX(), enemyPosition.getY());
        for (int i = 0; i < 10; ++i) {
            int n = (int)Math.round(myPosition.distance(point2D) / QuickHack.bulletVelocity(firePower));
            point2D = this.CTPredict(n);
        }
        return QuickHack.absoluteBearing(myPosition, point2D);
    }

    double RTGuess() {
        return QuickHack.absoluteBearing(myPosition, enemyPosition) + (double)enemyDirection * randomFactor * this.maxEscapeAngle(firePower);
    }

    double HOTGuess() {
        return QuickHack.absoluteBearing(myPosition, enemyPosition);
    }

    boolean equal(int n, int n2) {
        return Math.abs(patternVelocityHistory[n] - patternVelocityHistory[n2]) < 1.0E-6 && Math.abs(patternHeadingHistory[n] - patternHeadingHistory[n2]) < 1.0E-6;
    }

    boolean fequal(int n, int n2) {
        return Math.abs(fakeHistory[n] - fakeHistory[n2]) < 1.0E-6;
    }

    int substract(int n, int n2) {
        return (2500 + n - n2) % 2500;
    }

    double SPMGuess() {
        int n;
        int n2;
        Point2D.Double double_ = new Point2D.Double();
        int[] nArray = new int[75];
        int n3 = 0;
        int n4 = 0;
        nArray[0] = 0;
        int n5 = 0;
        int n6 = patternHistoryLooped ? 2500 : patternHistoryEnd;
        int n7 = Math.min(74, n6 - (int)(enemyDistance / QuickHack.bulletVelocity(firePower)) - 1);
        --patternHistoryEnd;
        for (n2 = 2; n2 <= n7; ++n2) {
            while (n4 != 0 && !this.equal(this.substract(patternHistoryEnd, n4), this.substract(patternHistoryEnd, n2 - 1))) {
                n4 = nArray[n4];
            }
            if (this.equal(this.substract(patternHistoryEnd, n4), this.substract(patternHistoryEnd, n2 - 1))) {
                ++n4;
            }
            if (n4 > n7) {
                for (n = 0; n < n7; ++n) {
                    this.out.print(nArray[n] + " ");
                }
                this.out.println();
            }
            nArray[n2] = n4;
        }
        n2 = 0;
        for (n = n7; n < n6; ++n) {
            while (n2 != 0 && !this.equal(this.substract(patternHistoryEnd, n2), this.substract(patternHistoryEnd, n))) {
                n2 = nArray[n2];
            }
            if (this.equal(this.substract(patternHistoryEnd, n2), this.substract(patternHistoryEnd, n))) {
                ++n2;
            }
            if (n5 < n2) {
                n5 = n2;
                n3 = this.substract(patternHistoryEnd, n);
            }
            if (n5 != n7) continue;
            n = n6;
        }
        double_.setLocation(enemyPosition);
        double d = enemyHeading;
        double d2 = enemyVelocity;
        n = 0;
        while ((double)n * QuickHack.bulletVelocity(firePower) < enemyDistance) {
            d2 = patternVelocityHistory[n3];
            ((Point2D)double_).setLocation(((Point2D)double_).getX() + d2 * Math.sin(d += patternHeadingHistory[n3]), ((Point2D)double_).getY() + d2 * Math.cos(d));
            ++n3;
            n3 %= 2500;
            ++n;
        }
        ++patternHistoryEnd;
        return QuickHack.absoluteBearing(myPosition, double_);
    }

    double FPMGuess() {
        int n;
        int n2;
        double d = 0.0;
        int[] nArray = new int[75];
        int n3 = 0;
        int n4 = 0;
        nArray[0] = 0;
        int n5 = 0;
        int n6 = patternHistoryLooped ? 2500 : patternHistoryEnd;
        int n7 = Math.min(74, n6 - (int)(enemyDistance / QuickHack.bulletVelocity(firePower)) - 1);
        --patternHistoryEnd;
        for (n2 = 2; n2 <= n7; ++n2) {
            while (n4 != 0 && !this.fequal(this.substract(patternHistoryEnd, n4), this.substract(patternHistoryEnd, n2 - 1))) {
                n4 = nArray[n4];
            }
            if (this.fequal(this.substract(patternHistoryEnd, n4), this.substract(patternHistoryEnd, n2 - 1))) {
                ++n4;
            }
            if (n4 > n7) {
                for (n = 0; n < n7; ++n) {
                    this.out.print(nArray[n] + " ");
                }
                this.out.println();
            }
            nArray[n2] = n4;
        }
        n2 = 0;
        for (n = n7; n < n6; ++n) {
            while (n2 != 0 && !this.fequal(this.substract(patternHistoryEnd, n2), this.substract(patternHistoryEnd, n))) {
                n2 = nArray[n2];
            }
            if (this.fequal(this.substract(patternHistoryEnd, n2), this.substract(patternHistoryEnd, n))) {
                ++n2;
            }
            if (n5 < n2) {
                n5 = n2;
                n3 = this.substract(patternHistoryEnd, n);
            }
            if (n5 != n7) continue;
            n = n6;
        }
        n = 0;
        while ((double)n * QuickHack.bulletVelocity(firePower) < enemyDistance) {
            d += Math.asin(fakeHistory[n3] / enemyDistance);
            ++n3;
            n3 %= 2500;
            ++n;
        }
        ++patternHistoryEnd;
        return QuickHack.absoluteBearing(myPosition, enemyPosition) + d;
    }

    Point2D CTPredict(long l) {
        Point2D.Double double_ = new Point2D.Double();
        if (0.001 < Math.abs(enemyPreviousHeading - enemyHeading)) {
            double d = enemyVelocity / (enemyPreviousHeading - enemyHeading);
            double d2 = enemyHeading + (double)l * (enemyPreviousHeading - enemyHeading);
            ((Point2D)double_).setLocation(enemyPosition.getX() + Math.cos(enemyHeading) * d - Math.cos(d2) * d, enemyPosition.getY() + Math.sin(d2) * d - Math.sin(enemyHeading) * d);
        } else {
            ((Point2D)double_).setLocation(enemyPosition.getX() + Math.sin(enemyHeading) * enemyVelocity * (double)l, enemyPosition.getY() + Math.cos(enemyHeading) * enemyVelocity * (double)l);
        }
        ((Point2D)double_).setLocation(Math.max(Math.min(((Point2D)double_).getX(), this.getBattleFieldWidth() - 18.0), 18.0), Math.max(Math.min(((Point2D)double_).getY(), this.getBattleFieldHeight() - 18.0), 18.0));
        return double_;
    }

    void patternRecord() {
        if (this.getTime() > 5L) {
            QuickHack.patternHeadingHistory[QuickHack.patternHistoryEnd] = Utils.normalRelativeAngle((double)(enemyPreviousHeading - enemyHeading));
            QuickHack.patternVelocityHistory[QuickHack.patternHistoryEnd] = enemyVelocity;
            QuickHack.fakeHistory[QuickHack.patternHistoryEnd] = enemyVelocity * Math.sin(enemyHeading - enemyBearing);
            if (++patternHistoryEnd == 2500) {
                patternHistoryLooped = true;
            }
            patternHistoryEnd %= 2500;
        }
    }

    void goTo() {
        double d = Utils.normalRelativeAngle((double)(QuickHack.absoluteBearing(myPosition, myDestination) - this.getHeadingRadians()));
        double d2 = myPosition.distance(myDestination);
        if (1.5707963267948966 < Math.abs(d)) {
            d2 *= -1.0;
            d += d < 0.0 ? Math.PI : -Math.PI;
        }
        this.setTurnRightRadians(d);
        this.setAhead(d2);
    }

    int distanceIndex() {
        return (int)(enemyDistance * 8.0 / 800.0);
    }

    double maxEscapeAngle(double d) {
        return Math.asin(8.0 / QuickHack.bulletVelocity(d));
    }

    public static double absoluteBearing(Point2D point2D, Point2D point2D2) {
        return 1.5707963267948966 - Math.atan2(point2D2.getY() - point2D.getY(), point2D2.getX() - point2D.getX());
    }

    static double bulletVelocity(double d) {
        return 20.0 - 3.0 * d;
    }

    int EEI() {
        if (enemyEnergy == 0.0) {
            return 0;
        }
        return 1;
    }

    int EDI() {
        if (enemyDistance < 350.0) {
            return 1;
        }
        return 2;
    }

    void loadData() {
        try {
            int n;
            GZIPInputStream gZIPInputStream = new GZIPInputStream(new FileInputStream(this.getDataFile(enemyName)));
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            VGStats = (int[][][])objectInputStream.readObject();
            for (n = 0; n < 2; ++n) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 5; ++j) {
                        QuickHack.VGStats[n][i][j] = (int)Math.ceil((double)VGStats[n][i][j] * 0.8);
                    }
                }
            }
            distanceStats = (int[][][])objectInputStream.readObject();
            for (n = 0; n < 8; ++n) {
                QuickHack.distanceStats[n][0][0] = (int)Math.ceil((double)distanceStats[n][0][0] * 0.8);
                QuickHack.distanceStats[n][0][1] = (int)Math.ceil((double)distanceStats[n][0][1] * 0.8);
            }
            boolean[] blArray = (boolean[])objectInputStream.readObject();
            musashiTrick = blArray[0];
            objectInputStream.close();
            gZIPInputStream.close();
        }
        catch (Exception exception) {
            this.out.println("Didn't load.");
        }
    }

    void saveData() {
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(enemyName)));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(VGStats);
            objectOutputStream.writeObject(distanceStats);
            boolean[] blArray = new boolean[]{musashiTrick};
            objectOutputStream.writeObject(blArray);
            objectOutputStream.flush();
            objectOutputStream.close();
            gZIPOutputStream.close();
        }
        catch (IOException iOException) {
            this.out.println("Didn't save.");
        }
    }

    static {
        gravTime = 0L;
        timeOfPreviousMovementAlgorithmChange = 0L;
        currentMovement = 0;
        distanceStats = new int[8][2][2];
        movementSelectorPower = 2.0;
        randomFactor = 0.0;
        firePower = 1.7;
        myDirection = 1;
        enemyDirection = 1;
        currentTargeting = 1;
        totalBullets = 0;
        randomizer = new Random();
        enemyName = "Sucker";
    }

    class virtualGunWave
    extends Condition {
        Point2D firePosition = new Point2D.Double();
        double bulletVelocity;
        double distance = 0.0;
        double[] guesses = new double[5];
        int[] stats;

        virtualGunWave() {
        }

        public boolean test() {
            double d;
            this.distance += this.bulletVelocity;
            if (d >= this.firePosition.distance(enemyPosition)) {
                for (int i = 0; i < 5; ++i) {
                    if (!(Math.abs(Utils.normalRelativeAngle((double)(this.guesses[i] - QuickHack.absoluteBearing(this.firePosition, enemyPosition)))) < Math.atan(20.0 / this.firePosition.distance(enemyPosition)))) continue;
                    int n = i;
                    this.stats[n] = this.stats[n] + 1;
                }
                ++totalBullets;
                QuickHack.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

