/*
 * Decompiled with CFR 0.152.
 */
package reaper;

import java.awt.geom.Point2D;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import reaper.Data;
import reaper.Reaper;
import robocode.RobocodeFileOutputStream;

public class Methods {
    private Reaper r;

    public void draaiGunRelatief(double degrees) {
        this.draaiGunNaarAbsoluut(this.absoluutTank(degrees));
    }

    public void draaiRadarRelatief(double degrees) {
        this.draaiRadarNaarAbsoluut(this.absoluutTank(degrees));
    }

    public void draaiGunNaarAbsoluut(double degrees) {
        this.r.setTurnGunRight(this.relatiefGun(degrees));
    }

    public void draaiRadarNaarAbsoluut(double degrees) {
        this.r.setTurnRadarRight(this.relatiefRadar(degrees));
    }

    public void draaiZelfAbsoluut(double degrees) {
        this.r.setTurnRight(this.relatiefTank(degrees));
    }

    public double absoluutTank(double relatiefTank) {
        return Methods.normalizeAbsoluut(relatiefTank + this.getHeading());
    }

    public double absoluutGun(double relatiefGun) {
        return Methods.normalizeAbsoluut(relatiefGun + this.getGunHeading());
    }

    public double absoluutRadar(double relatiefRadar) {
        return Methods.normalizeAbsoluut(relatiefRadar + this.getRadarHeading());
    }

    public double relatiefGun(double absoluut) {
        double relatief = absoluut - this.getGunHeading();
        while (relatief <= -180.0) {
            relatief += 360.0;
        }
        while (relatief > 180.0) {
            relatief -= 360.0;
        }
        return relatief;
    }

    public double relatiefRadar(double absoluut) {
        double relatief = absoluut - this.getRadarHeading();
        while (relatief <= -180.0) {
            relatief += 360.0;
        }
        while (relatief > 180.0) {
            relatief -= 360.0;
        }
        return relatief;
    }

    public double relatiefTank(double absoluut) {
        double relatief = absoluut - this.getHeading();
        while (relatief <= -180.0) {
            relatief += 360.0;
        }
        while (relatief > 180.0) {
            relatief -= 360.0;
        }
        return relatief;
    }

    public static double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Methods.getDistance(x1, y1, x2, y2);
        double arcSin = Math.toDegrees(Math.asin(xo / hyp));
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = 360.0 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = 180.0 - arcSin;
        }
        return bearing;
    }

    public static double getDistance(double x1, double y1, double x2, double y2) {
        Point2D.Double punt1 = new Point2D.Double(x1, y1);
        Point2D.Double punt2 = new Point2D.Double(x2, y2);
        return punt1.distance(punt2);
    }

    public static double normalizeBearing(double angle) {
        while (angle > 180.0) {
            angle -= 360.0;
        }
        while (angle < -180.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void writeData(ArrayList robotNamen, ArrayList data, ArrayList battles, ArrayList movesets, ArrayList bearingData) {
        try {
            ObjectOutputStream o = new ObjectOutputStream((OutputStream)new RobocodeFileOutputStream(this.r.getDataFile("ReaperData.sg")));
            if (robotNamen.size() > 150) {
                System.out.println("Removing data, too many robots stored");
                robotNamen.remove(0);
                data.remove(0);
                battles.remove(0);
                movesets.remove(0);
                bearingData.remove(0);
            }
            o.writeObject(robotNamen);
            o.writeObject(data);
            o.writeObject(battles);
            o.writeObject(movesets);
            o.writeObject(bearingData);
            o.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public double getHeading() {
        return this.r.getHeading();
    }

    public double getGunHeading() {
        return this.r.getGunHeading();
    }

    public double getRadarHeading() {
        return this.r.getRadarHeading();
    }

    public void loadData() {
        try {
            ObjectInputStream i = new ObjectInputStream(new FileInputStream(this.r.getDataFile("ReaperData.sg")));
            this.r.setNamen((ArrayList)i.readObject());
            this.r.setData((ArrayList)i.readObject());
            this.r.setBattles((ArrayList)i.readObject());
            this.r.setMoveSets((ArrayList)i.readObject());
            this.r.setBearingData((ArrayList)i.readObject());
            i.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double normalizeRelatief(double hoek) {
        while (hoek <= -180.0) {
            hoek += 360.0;
        }
        while (hoek > 180.0) {
            hoek -= 360.0;
        }
        return hoek;
    }

    public static double normalizeAbsoluut(double hoek) {
        while (hoek < 0.0) {
            hoek += 360.0;
        }
        while (hoek >= 360.0) {
            hoek -= 360.0;
        }
        return hoek;
    }

    public boolean closeToWall() {
        return this.r.getY() < Data.evadeWall || this.r.getX() < Data.evadeWall || this.r.getX() > this.r.getFieldWidth() - Data.evadeWall || this.r.getY() > this.r.getFieldHeight() - Data.evadeWall;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public Methods(Reaper r) {
        this.r = r;
    }
}

