/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringSolution;
import pedersen.divination.WaveInboundImpl;
import pedersen.divination.WaveOutboundImpl;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.Wave;
import pedersen.physics.constant.VehicleImpl;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;
import pedersen.util.Constraints;
import robocode.Bullet;

public class CombatWaveBank
extends DebuggableBase
implements OnRound {
    private final Set<CombatWave> outbound = new HashSet<CombatWave>();
    private final Set<CombatWave> inbound = new HashSet<CombatWave>();
    private long totalOutbound = 0L;
    private long totalInbound = 0L;
    private long matchCountInbound = 0L;
    private long matchTotalInbound = 0L;
    private static final CombatWaveBank singleton = new CombatWaveBank();

    private CombatWaveBank() {
        NotificationSubsystem.getInstance().subscribeOnRound(this);
    }

    public static CombatWaveBank getInstance() {
        return singleton;
    }

    public void add(WaveOutboundImpl wave) {
        this.outbound.add(wave);
        ++this.totalOutbound;
    }

    public void add(WaveInboundImpl wave) {
        this.inbound.add(wave);
        ++this.totalInbound;
    }

    public void process() {
        this.removeUselessWaves();
        for (CombatWave wave : this.outbound) {
            wave.process();
        }
        for (CombatWave wave : this.inbound) {
            wave.process();
        }
    }

    public CombatWave findInboundWaveByBullet(long time, Bullet bullet) {
        CombatWave combatWave = this.findWaveByBullet(this.inbound, time, bullet);
        if (combatWave != null) {
            ++this.matchCountInbound;
        }
        ++this.matchTotalInbound;
        return combatWave;
    }

    private CombatWave findWaveByBullet(Collection<CombatWave> waves, long time, Bullet bullet) {
        VehicleImpl bulletChassis = new VehicleImpl(bullet.getX(), bullet.getY(), bullet.getHeadingRadians(), bullet.getVelocity());
        for (CombatWave wave : waves) {
            if (!wave.getVelocity().equalsVelocity(bulletChassis)) continue;
            Position p0 = wave.getPosition().addVector((HasDirection)bulletChassis, wave.radius(time - 1L));
            Position p1 = wave.getPosition().addVector((HasDirection)bulletChassis, wave.radius(time));
            if (!bulletChassis.getPosition().equalsPosition(p0) && !bulletChassis.getPosition().equalsPosition(p1)) continue;
            return wave;
        }
        return null;
    }

    public boolean doesAnyInboundWaveInterceptChassisPosition(long time, HasPosition position) {
        boolean intercepted = false;
        for (CombatWave wave : this.inbound) {
            double waveDistance;
            double waveRadius = wave.radius(time);
            if (waveRadius < (waveDistance = wave.getPosition().getDistance(position).distance() + Constraints.vehicleRadius)) {
                for (FiringSolution firingSolution : wave.getFiringSolutions()) {
                    Position adjustedPosition = wave.getPosition().addVector((HasDirection)firingSolution.getDirection().getRelativeDirection(wave.getPosition().getBearing(position)), wave.getPosition().getDistance(position));
                    if (Constraints.isInRange(-Constraints.vehicleRadius, adjustedPosition.getX() - wave.getPosition().getX(), Constraints.vehicleRadius)) {
                        intercepted = true;
                    }
                    if (intercepted) break;
                }
            }
            if (intercepted) break;
        }
        return intercepted;
    }

    private void removeUselessWaves() {
        CombatWave e;
        Iterator<CombatWave> iterator = this.outbound.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e.isWaveUseful()) continue;
            e.teardown();
            iterator.remove();
        }
        iterator = this.inbound.iterator();
        while (iterator.hasNext()) {
            e = iterator.next();
            if (e.isWaveUseful()) continue;
            e.teardown();
            iterator.remove();
        }
    }

    @Override
    public void onRound(int round) {
        Iterator<CombatWave> iterator = this.outbound.iterator();
        while (iterator.hasNext()) {
            iterator.next().teardown();
            iterator.remove();
        }
        iterator = this.inbound.iterator();
        while (iterator.hasNext()) {
            iterator.next().teardown();
            iterator.remove();
        }
    }

    public void cancelWavesViaComms(Wave wave) {
    }

    public Iterable<CombatWave> getOutboundWaves() {
        return new ArrayList<CombatWave>(this.outbound);
    }

    public Iterable<CombatWave> getInboundWaves() {
        return new ArrayList<CombatWave>(this.inbound);
    }

    public boolean isWaveInbound() {
        return this.inbound.size() > 0;
    }

    public boolean isWaveOutbound() {
        return this.outbound.size() > 0;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("Outbound: ").append(this.outbound.size()).append(" entries, ").append(this.totalOutbound).append(" processed.");
        buffer.append("\n").append("Inbound: ").append(this.inbound.size()).append(" entries, ").append(this.totalInbound).append(" processed.");
        buffer.append("\n").append("Found " + this.matchCountInbound + " inbound waves out of " + this.matchTotalInbound + " attempts. (" + super.trim(100.0 * (double)this.matchCountInbound / (double)this.matchTotalInbound) + "%)");
        return buffer.toString();
    }
}

