/*
 * Decompiled with CFR 0.152.
 */
package grybgoofy;

public class GMath {
    static final double PI = Math.PI;

    public static double toRadians(double theta) {
        return theta / 360.0 * (Math.PI * 2);
    }

    public static double toDegrees(double theta) {
        return theta / (Math.PI * 2) * 360.0;
    }

    public static double toPhi(double theta) {
        return GMath.intervalize(7.853981633974483 - theta, 0.0, Math.PI * 2);
    }

    public static double intervalize(double theta, double min, double max) {
        return GMath.intervalize(theta, min, max, max - min);
    }

    public static double intervalize(double theta, double min, double max, double cycle) {
        if (theta < min) {
            return GMath.intervalize(theta + cycle, min, max, cycle);
        }
        if (theta > max) {
            return GMath.intervalize(theta - cycle, min, max, cycle);
        }
        return theta;
    }

    public static double abs(double x) {
        return Math.abs(x);
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double distance(double x, double y) {
        return GMath.sqrt(GMath.sqr(x) + GMath.sqr(y));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return GMath.distance(x1 - x2, y1 - y2);
    }

    public static double distance(double[] p, double[] q) {
        return GMath.distance(p[0] - q[0], p[1] - q[1]);
    }

    public static double sin(double theta) {
        return Math.sin(theta);
    }

    public static double asin(double theta) {
        return Math.asin(theta);
    }

    public static double cos(double theta) {
        return Math.cos(theta);
    }

    public static double acos(double theta) {
        return Math.acos(theta);
    }

    public static double tan(double theta) {
        return Math.tan(theta);
    }

    public static double atan(double theta) {
        return Math.atan(theta);
    }

    public static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }

    public static double atan2(double[] p, double[] q) {
        return Math.atan2(p[1] - q[1], p[0] - q[0]);
    }

    public static double sign(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        return GMath.abs(x) / x;
    }

    public static double random(double x) {
        return x * Math.random();
    }
}

