/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.radar;

import dmh.robocode.data.Location;
import dmh.robocode.radar.RadarCommand;
import dmh.robocode.robot.CommandBasedRobot;
import dmh.robocode.utils.Geometry;
import java.awt.Graphics2D;

public class RadarFullScan
implements RadarCommand {
    private boolean startedTurn = false;
    long startingTime;
    private CommandBasedRobot myRobot;
    private double scanDirection;

    public RadarFullScan(CommandBasedRobot myRobot) {
        this.startingTime = myRobot.getTime();
        this.myRobot = myRobot;
        this.setupScanTowardsCentre(myRobot);
    }

    private void setupScanTowardsCentre(CommandBasedRobot myRobot) {
        Location centre = new Location(myRobot.getBattleFieldWidth() / 2.0, myRobot.getBattleFieldHeight() / 2.0);
        double headingTowardsCentre = Geometry.getBearingBetweenLocations(myRobot.getLocation(), centre);
        this.scanDirection = Geometry.getRelativeBearing(myRobot.getRadarHeading(), headingTowardsCentre) >= 0.0 ? 1.0 : -1.0;
    }

    @Override
    public boolean isDone() {
        return this.startedTurn && this.myRobot.getRadarTurnRemaining() == 0.0 || this.myRobot.getEnemies().getNumberOfLiveEnemiesSeenSince(this.startingTime) >= this.myRobot.getOthers();
    }

    @Override
    public double getRightTurn() {
        if (this.startedTurn) {
            return this.myRobot.getRadarTurnRemaining();
        }
        return 360.0 * this.scanDirection;
    }

    @Override
    public void executed() {
        this.startedTurn = true;
    }

    @Override
    public void paint(Graphics2D g) {
    }
}

