/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Movement.DangerPrediction;

import rdt.AgentSmith.Movement.DangerPrediction.DangerCalculationBase;
import rdt.AgentSmith.Movement.EnemyWaveManager;

public class MinDistanceDangerCalculation
extends DangerCalculationBase {
    private double _minDistanceToTargetSq = 1000000.0;

    public MinDistanceDangerCalculation(EnemyWaveManager enemyWaveManager) {
        super(enemyWaveManager);
    }

    @Override
    public double GetDanger(long absTick, double x, double y) {
        double minDistance = Double.MAX_VALUE;
        int numEnemyWaves = this.GetNumEnemyWaves();
        int waveIndex = 0;
        while (waveIndex < numEnemyWaves) {
            double waveDistance = this.GetDistanceSqToClosestPredictedWave(waveIndex, absTick, x, y);
            if (waveDistance > minDistance) break;
            minDistance = waveDistance;
            ++waveIndex;
        }
        double distanceToTargetSq = this.GetDistanceToTargetSq(x, y);
        minDistance = Math.min(minDistance, distanceToTargetSq);
        double danger = 1.0 / minDistance;
        if (distanceToTargetSq < this._minDistanceToTargetSq) {
            danger *= (this._minDistanceToTargetSq - distanceToTargetSq) / this._minDistanceToTargetSq;
        }
        return danger;
    }
}

