/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.util.Coord;
import java.util.List;
import java.util.ListIterator;

class DisplacementPrediction
extends TargetPrediction {
    private int period = 0;

    public DisplacementPrediction() {
        this(0);
    }

    public DisplacementPrediction(int period) {
        this.period = period;
    }

    public Coord predictTarget(List recentFootprints, long time) {
        long predictgap;
        Coord predictPos = null;
        ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
        Footprint mostRecentFp = (Footprint)lit.previous();
        long gobackgap = predictgap = time - mostRecentFp.getTime();
        if (this.period != 0 && (long)this.period < gobackgap) {
            gobackgap = this.period;
        }
        Footprint earlierFp = mostRecentFp;
        while (lit.hasPrevious() && mostRecentFp.getTime() - earlierFp.getTime() < gobackgap) {
            earlierFp = (Footprint)lit.previous();
        }
        long observedGap = mostRecentFp.getTime() - earlierFp.getTime();
        if (observedGap == 0L) {
            predictPos = mostRecentFp.getPosition();
        } else {
            double xvel = (mostRecentFp.getPosition().getX() - earlierFp.getPosition().getX()) / (double)observedGap;
            double yvel = (mostRecentFp.getPosition().getY() - earlierFp.getPosition().getY()) / (double)observedGap;
            double newx = mostRecentFp.getPosition().getX() + xvel * (double)predictgap;
            double newy = mostRecentFp.getPosition().getY() + yvel * (double)predictgap;
            predictPos = new Coord(newx, newy);
        }
        return predictPos;
    }

    public String toString() {
        return "Displacement(" + this.period + ")";
    }
}

