/*
 * Decompiled with CFR 0.152.
 */
package ab;

import robocode.Robot;
import robocode.ScannedRobotEvent;

public class SuperEnemyBot {
    private double x;
    private double y;
    private double bearing;
    private double distance;
    private double energy;
    private double heading;
    private double velocity;
    private String name;

    SuperEnemyBot() {
        this.reset();
    }

    public void reset() {
        this.bearing = 0.0;
        this.distance = 0.0;
        this.energy = 0.0;
        this.heading = 0.0;
        this.velocity = 0.0;
        this.name = "";
        this.x = 0.0;
        this.y = 0.0;
    }

    public void update(ScannedRobotEvent e, Robot robot) {
        double absBearingDeg = robot.getHeading() + e.getBearing();
        if (absBearingDeg < 0.0) {
            absBearingDeg += 360.0;
        }
        this.bearing = e.getBearingRadians();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        this.heading = e.getHeadingRadians();
        this.velocity = e.getVelocity();
        this.name = e.getName();
        this.x = robot.getX() + Math.sin(Math.toRadians(absBearingDeg)) * e.getDistance();
        this.y = robot.getY() + Math.cos(Math.toRadians(absBearingDeg)) * e.getDistance();
    }

    public double getBearing() {
        return this.bearing;
    }

    public double getDistance() {
        return this.distance;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public String getName() {
        return this.name;
    }

    public boolean none() {
        return this.name.length() == 0;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }
}

