/*
 * Decompiled with CFR 0.152.
 */
package tmnr;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;

public class Raphael
extends TeamRobot {
    private static Point2D.Double currentLocation;
    private static double distanceLeft;
    private static Point2D.Double lastPosition;
    private static double distClosest;
    private static Point2D.Double destination;
    private static HashMap<String, Robot> robots;
    private static Robot target;
    private static Robot closest;
    private static Rectangle2D.Double field;
    private static double myEnergy;
    private static List<Wave> waves;
    private static int direction;
    private static int[][] stats;

    static {
        waves = new ArrayList<Wave>();
        stats = new int[13][101];
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.setColors(new Color(0, 100, 0), new Color(230, 0, 0), Color.black);
        field = new Rectangle2D.Double(35.0, 35.0, this.getBattleFieldWidth() - 70.0, this.getBattleFieldHeight() - 70.0);
        robots = new HashMap();
        target = new Robot();
        closest = new Robot();
        currentLocation = destination = new Point2D.Double(this.getX(), this.getY());
        lastPosition = Raphael.destination;
        closest.pos = Raphael.destination;
        while (true) {
            myEnergy = this.getEnergy();
            currentLocation = new Point2D.Double(this.getX(), this.getY());
            distClosest = currentLocation.distance(closest.pos);
            this.move();
            this.execute();
        }
    }

    private void move() {
        distanceLeft = currentLocation.distance(destination);
        if (distanceLeft <= 15.0) {
            int i = 0;
            do {
                Point2D.Double test;
                if (!field.contains(test = Raphael.getPoint(currentLocation, (double)i * Math.PI / 75.0, Math.min(distClosest, 50.0 + Math.random() * 200.0))) || !(this.getRisk(test) < this.getRisk(destination))) continue;
                destination = test;
            } while (i++ < 300);
            lastPosition = currentLocation;
        } else {
            double angle = Raphael.absoluteBearing(currentLocation, destination) - this.getHeadingRadians();
            double direction = 1.0;
            if (Math.cos(angle) < 0.0) {
                angle += Math.PI;
                direction = -1.0;
            }
            this.setAhead(distanceLeft * direction);
            angle = Utils.normalRelativeAngle((double)angle);
            this.setTurnRightRadians(angle);
            this.setMaxVelocity(Math.abs(angle) > 1.0 ? 0 : 8);
        }
    }

    private double getRisk(Point2D.Double destination) {
        double risk = 0.1 / destination.distanceSq(lastPosition);
        for (Robot rob : robots.values()) {
            if (rob.alive) {
                risk += Math.min(rob.energy / myEnergy, 2.0) * (1.0 + Math.abs(Math.cos(Raphael.absoluteBearing(destination, currentLocation) - Raphael.absoluteBearing(currentLocation, rob.pos)))) / destination.distanceSq(rob.pos);
            }
            try {
                if (!rob.team || !(Math.abs(Raphael.absoluteBearing(rob.pos, destination) - Raphael.absoluteBearing(rob.pos, rob.target.pos)) < 0.20943951023931953)) continue;
                risk += Double.POSITIVE_INFINITY;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return risk;
    }

    public void onHitRobot(HitRobotEvent e) {
        destination = currentLocation;
        this.move();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        robots.get(e.getName()).alive = false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Robot rob = robots.get(e.getName());
        if (rob == null) {
            rob = new Robot();
            robots.put(e.getName(), rob);
            rob.team = this.isTeammate(e.getName());
        }
        rob.absBearing = e.getBearingRadians() + this.getHeadingRadians();
        rob.energy = e.getEnergy();
        rob.alive = true;
        rob.heading = e.getHeadingRadians();
        rob.pos = Raphael.getPoint(Raphael.currentLocation, rob.absBearing, e.getDistance());
        if (currentLocation.distance(closest.pos) < 10.0) {
            destination = currentLocation;
            this.move();
        }
        if (!(rob.team || target.alive && !(e.getDistance() < currentLocation.distance(target.pos)))) {
            target = rob;
        }
        if (!closest.alive || e.getDistance() < currentLocation.distance(closest.pos)) {
            closest = rob;
        }
        try {
            int i = 0;
            while (i < waves.size()) {
                Wave currentWave = waves.get(i);
                if (currentWave.isHit(((Robot)Raphael.target).pos.x, ((Robot)Raphael.target).pos.y, this.getTime())) {
                    --i;
                    waves.remove(currentWave);
                }
                ++i;
            }
        }
        catch (Exception i) {
            // empty catch block
        }
        double power = 3.0 - (20.0 - myEnergy) / 6.0;
        if (power > 3.0) {
            power = 3.0;
        } else if (power < 0.1) {
            power = 0.1;
        }
        if (target.velocity != 0.0) {
            direction = Math.sin(rob.heading - rob.absBearing) * e.getVelocity() < 0.0 ? -1 : 1;
        }
        int[] currentStats = stats[(int)(e.getDistance() / 100.0)];
        Wave wv = new Wave(this.getX(), this.getY(), rob.absBearing, power, direction, this.getTime(), currentStats);
        int best = (stats.length - 1) / 2;
        int i = 0;
        while (i < stats.length) {
            if (currentStats[best] < currentStats[i]) {
                best = i;
            }
            ++i;
        }
        double guess = (double)(best - (stats.length - 1) / 2) / (double)((stats.length - 1) / 2);
        double angleOffset = (double)direction * guess * wv.maxEscapeAngle();
        double gunTurnRadians = Utils.normalRelativeAngle((double)(target.absBearing - this.getGunHeadingRadians() + angleOffset));
        if (myEnergy > 1.0 && target.alive && this.getGunHeat() == 0.0 && gunTurnRadians < Math.atan2(9.0, e.getDistance()) && this.setFireBullet(power) != null) {
            waves.add(wv);
        }
        this.setTurnGunRightRadians(gunTurnRadians);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static Point2D.Double getPoint(Point2D.Double source, double angle, double length) {
        return new Point2D.Double(source.x + Math.sin(angle) * length, source.y + Math.cos(angle) * length);
    }

    class Robot {
        private double energy;
        private double heading;
        private double absBearing;
        private double velocity;
        private Point2D.Double pos;
        private boolean alive = false;
        private boolean team = false;
        private Robot target;

        Robot() {
        }
    }

    class Wave {
        private double sourceX;
        private double sourceY;
        private double sourceBearing;
        private double firePower;
        private double direction;
        private long fireTime;
        private int[] segment;

        public boolean isHit(double enemyX, double enemyY, long currentTime) {
            if ((double)(currentTime - this.fireTime) * this.getBulletSpeed() >= Point2D.distance(this.sourceX, this.sourceY, enemyX, enemyY)) {
                int index;
                double actualAngle = Math.atan2(enemyX - this.sourceX, enemyY - this.sourceY);
                double angleOffset = Utils.normalRelativeAngle((double)(actualAngle - this.sourceBearing));
                double guessFactor = Math.max(-1.0, Math.min(1.0, angleOffset / this.maxEscapeAngle())) * this.direction;
                int n = index = (int)Math.round((double)((this.segment.length - 1) / 2) * (guessFactor + 1.0));
                this.segment[n] = this.segment[n] + 1;
                return true;
            }
            return false;
        }

        public double getBulletSpeed() {
            return 20.0 - this.firePower * 3.0;
        }

        public double maxEscapeAngle() {
            return Math.asin(8.0 / this.getBulletSpeed());
        }

        public Wave(double x, double y, double bearing, double power, int direction, long time, int[] segment) {
            this.sourceX = x;
            this.sourceY = y;
            this.sourceBearing = bearing;
            this.firePower = power;
            this.fireTime = time;
            this.direction = direction;
            this.segment = segment;
        }
    }
}

