/*
 * Decompiled with CFR 0.152.
 */
package ao;

import ao.Enemy;
import ao.GravBullet;
import ao.VirtualBullet;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class T100
extends AdvancedRobot {
    static final double target_range = 500.0;
    static final double target_force = -2.0;
    static final double bullet_range = 500.0;
    static final double bullet_force = -2.0;
    static final double WallForce = 3000.0;
    static final int analize_count = 10;
    static final int max_analize_count = 50;
    Enemy target;
    Enemy target_0;
    Enemy target_1;
    ArrayList<GravBullet> enemy_bullets;
    ArrayList<VirtualBullet> my_bullets;
    static double[][] hit = new double[4][4];
    static double[][] miss = new double[4][4];
    static double[] enemy_hit = new double[3];
    static double[] enemy_fired = new double[3];
    private int fire_strategy = 0;
    private int enemy_movement = 0;
    private int enemy_fire_strategy = 0;
    private int timeSinceLastScan = 10;
    private double W;
    private double H;
    private double X;
    private double Y;
    private double heading;
    private double prevheading;
    private double speed;
    private boolean analizing = true;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.target = new Enemy();
        this.enemy_bullets = new ArrayList();
        this.my_bullets = new ArrayList();
        this.W = this.getBattleFieldWidth();
        this.H = this.getBattleFieldHeight();
        while (true) {
            this.X = this.getX();
            this.Y = this.getY();
            this.prevheading = this.heading;
            this.heading = this.getHeadingRadians();
            this.speed = this.getVelocity();
            this.doRadar();
            this.analizeEnemy();
            if (this.target.alive) {
                this.doGun();
            }
            this.doMove();
            this.execute();
        }
    }

    private void doRadar() {
        ++this.timeSinceLastScan;
        double radarOffset = Double.POSITIVE_INFINITY;
        if (this.getOthers() == 1 && this.timeSinceLastScan < 6) {
            radarOffset = Utils.normalRelativeAngle((double)(this.getRadarHeadingRadians() - this.target.absbearing));
            radarOffset += Math.signum(radarOffset) * 0.05;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    private void analizeEnemy() {
        this.DetermineEnemyMovement();
        this.target_1 = this.target_0;
        this.target_0 = new Enemy(this.target);
        if (this.analizing) {
            this.SetFiringStrategyforAnalisys();
        } else {
            this.SetFiringStrategy();
        }
    }

    public void doMove() {
        double xForce = 0.0;
        double yForce = 0.0;
        if (this.target.distance < 500.0) {
            double tank_tank_absbearing = this.absbearing(this.target.x, this.target.y, this.X, this.Y);
            double dgr90 = this.target.absbearing - tank_tank_absbearing > 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            xForce -= Math.sin(this.target.absbearing + dgr90) / this.target.distance * -2.0;
            yForce -= Math.cos(this.target.absbearing + dgr90) / this.target.distance * -2.0;
        }
        long ctime = this.getTime();
        ArrayList<GravBullet> rem = new ArrayList<GravBullet>();
        for (GravBullet b : this.enemy_bullets) {
            double dgr90;
            b.NewPos(ctime);
            if (b.cX <= 0.0 || b.cX >= this.W || b.cY <= 0.0 || b.cY >= this.H) {
                rem.add(b);
                continue;
            }
            b.distance = Math.sqrt(Math.pow(this.X - b.cX, 2.0) + Math.pow(this.getY() - b.cY, 2.0));
            double bullet_tank_absbearing = this.absbearing(b.cX, b.cY, this.X, this.Y);
            double d = dgr90 = b.absbearing - bullet_tank_absbearing > 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            if (!(b.distance < 500.0) || !(Math.abs(b.absbearing - bullet_tank_absbearing) < 1.5707963267948966)) continue;
            xForce -= Math.sin(b.absbearing + dgr90) / b.distance * -2.0;
            yForce -= Math.cos(b.absbearing + dgr90) / b.distance * -2.0;
        }
        for (GravBullet b : rem) {
            this.enemy_bullets.remove(b);
        }
        if (this.X < 200.0 || this.Y < 200.0 || this.X > this.W - 200.0 || this.Y > this.H - 200.0) {
            xForce += 3000.0 * (1.0 / Math.pow(this.X, 2.0) - 1.0 / Math.pow(this.W - this.X, 2.0));
            yForce += 3000.0 * (1.0 / Math.pow(this.Y, 2.0) - 1.0 / Math.pow(this.H - this.Y, 2.0));
        }
        if (xForce != 0.0 || yForce != 0.0) {
            double turnangle = Math.asin(Math.sin(Math.atan2(xForce, yForce) - this.getHeadingRadians()));
            double turn_ratio = Math.abs(turnangle) / 2.0943951023931953;
            if (turn_ratio > 1.0) {
                turn_ratio = 1.0;
            }
            this.setTurnRightRadians(turnangle);
            this.setAhead(-10.0 + (1.0 - turn_ratio) * 40.0);
        }
    }

    private void doGun() {
        double hit_ratio = hit[this.fire_strategy][this.enemy_movement] / (hit[this.fire_strategy][this.enemy_movement] + miss[this.fire_strategy][this.enemy_movement]);
        double bullet_power = 6.0 * hit_ratio;
        if (this.analizing) {
            bullet_power = 0.2;
        }
        if (bullet_power < 0.1) {
            bullet_power = 0.1;
        }
        if (this.target.distance < 100.0) {
            this.setTurnGunRightRadians(Math.asin(Math.sin(this.target.absbearing - this.getGunHeadingRadians())));
            this.setFireBullet(3.0);
            return;
        }
        switch (this.fire_strategy) {
            case 0: {
                this.setTurnGunRightRadians(Math.asin(Math.sin(this.target.absbearing - this.getGunHeadingRadians())));
                this.AddBullet(this.setFireBullet(bullet_power));
                break;
            }
            case 1: {
                Point2D.Double my_pos = new Point2D.Double(this.X, this.Y);
                Point2D.Double enemy_pos = new Point2D.Double(this.target.x, this.target.y);
                Point2D.Double predicted_pos = this.LinearPrediction(my_pos, enemy_pos, this.target.heading, this.target.speed, bullet_power);
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(T100.angle(my_pos, predicted_pos) - this.getGunHeadingRadians())));
                this.AddBullet(this.setFireBullet(bullet_power));
                break;
            }
            case 2: {
                Point2D.Double my_pos = new Point2D.Double(this.X, this.Y);
                Point2D.Double enemy_pos = new Point2D.Double(this.target.x, this.target.y);
                Point2D.Double predicted_pos = this.RadialPrediction(my_pos, enemy_pos, this.target.heading, this.target_0.heading, this.target.speed, bullet_power);
                this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(T100.angle(my_pos, predicted_pos) - this.getGunHeadingRadians())));
                this.AddBullet(this.setFireBullet(bullet_power));
                break;
            }
            case 3: {
                double offset = 0.15707963267948966 * (1.0 - this.target.distance / Math.sqrt(this.W * this.W + this.H * this.H)) * (Math.random() - 0.5);
                this.setTurnGunRightRadians(Math.asin(Math.sin(this.target.absbearing + offset - this.getGunHeadingRadians())));
                this.AddBullet(this.setFireBullet(bullet_power));
            }
        }
    }

    private void AddBullet(Bullet b) {
        this.my_bullets.add(new VirtualBullet(b, this.enemy_movement, this.fire_strategy));
    }

    private void AddEnemyBullet(double bulletpower) {
        Point2D.Double my_pred_pos;
        Point2D.Double my_pos = new Point2D.Double(this.X, this.Y);
        Point2D.Double enemy_pos = new Point2D.Double(this.target.x, this.target.y);
        switch (this.enemy_fire_strategy) {
            case 0: {
                my_pred_pos = new Point2D.Double(this.X, this.Y);
                break;
            }
            case 1: {
                my_pred_pos = this.LinearPrediction(enemy_pos, my_pos, this.heading, this.speed, bulletpower);
                break;
            }
            default: {
                my_pred_pos = this.RadialPrediction(enemy_pos, my_pos, this.heading, this.prevheading, this.speed, bulletpower);
            }
        }
        this.enemy_bullets.add(new GravBullet(this.target.x, this.target.y, 20.0 - 3.0 * bulletpower, this.absbearing(this.target.x, this.target.y, my_pred_pos.x, my_pred_pos.y), this.target.ctime, this.enemy_fire_strategy));
        int n = this.enemy_fire_strategy;
        enemy_fired[n] = enemy_fired[n] + 1.0;
    }

    private void DetermineEnemyMovement() {
        this.enemy_movement = 0;
        if (this.target.speed == 0.0) {
            this.enemy_movement = 1;
        } else if (this.target_0 != null) {
            if (this.target.heading == this.target_0.heading) {
                this.enemy_movement = 2;
            } else if (this.target_1 != null && this.target.heading - this.target_0.heading == this.target_0.heading - this.target_1.heading) {
                this.enemy_movement = 3;
            }
        }
    }

    private void SetFiringStrategy() {
        if (this.target.energy == 0.0) {
            this.fire_strategy = 0;
            return;
        }
        double max_hit_ratio = hit[0][this.enemy_movement] / (hit[0][this.enemy_movement] + miss[0][this.enemy_movement]);
        this.fire_strategy = 0;
        int i = 1;
        while (i < 4) {
            double new_hit_ratio = hit[i][this.enemy_movement] / (hit[i][this.enemy_movement] + miss[i][this.enemy_movement]);
            if (max_hit_ratio < new_hit_ratio) {
                max_hit_ratio = new_hit_ratio;
                this.fire_strategy = i;
            }
            ++i;
        }
    }

    private void SetFiringStrategyforAnalisys() {
        int i = 0;
        while (i < 4) {
            int sum = 0;
            int j = 0;
            while (j < 4) {
                sum = (int)((double)sum + (hit[i][j] + miss[i][j]));
                ++j;
            }
            if (sum < 10) {
                this.fire_strategy = i;
                return;
            }
            ++i;
        }
        this.analizing = false;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
        this.target.x = this.X + Math.sin(absbearing_rad) * e.getDistance();
        this.target.y = this.Y + Math.cos(absbearing_rad) * e.getDistance();
        this.target.bearing = e.getBearingRadians();
        this.target.heading = e.getHeadingRadians();
        this.target.absbearing = this.getHeadingRadians() + this.target.bearing;
        this.target.ctime = this.getTime();
        this.target.speed = e.getVelocity();
        this.target.distance = e.getDistance();
        double newtargetEnergy = e.getEnergy();
        if (this.target.energy > newtargetEnergy) {
            double bulletpower = this.target.energy - newtargetEnergy;
            this.AddEnemyBullet(bulletpower);
        }
        this.target.energy = newtargetEnergy;
        this.timeSinceLastScan = 0;
    }

    public void onBulletHit(BulletHitEvent e) {
        VirtualBullet rem = null;
        for (VirtualBullet b : this.my_bullets) {
            if (e.getBullet() != b.bullet) continue;
            rem = b;
            break;
        }
        if (rem != null) {
            double[] dArray = hit[rem.fire_str];
            int n = rem.move_str;
            dArray[n] = dArray[n] + 1.0;
            if (hit[rem.fire_str][rem.move_str] + miss[rem.fire_str][rem.move_str] > 50.0) {
                double[] dArray2 = hit[rem.fire_str];
                int n2 = rem.move_str;
                dArray2[n2] = dArray2[n2] / 2.0;
                double[] dArray3 = miss[rem.fire_str];
                int n3 = rem.move_str;
                dArray3[n3] = dArray3[n3] / 2.0;
            }
            this.my_bullets.remove(rem);
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
        VirtualBullet rem = null;
        for (VirtualBullet b : this.my_bullets) {
            if (e.getBullet() != b.bullet) continue;
            rem = b;
            break;
        }
        if (rem != null) {
            double[] dArray = miss[rem.fire_str];
            int n = rem.move_str;
            dArray[n] = dArray[n] + 1.0;
            if (hit[rem.fire_str][rem.move_str] + miss[rem.fire_str][rem.move_str] > 50.0) {
                double[] dArray2 = hit[rem.fire_str];
                int n2 = rem.move_str;
                dArray2[n2] = dArray2[n2] / 2.0;
                double[] dArray3 = miss[rem.fire_str];
                int n3 = rem.move_str;
                dArray3[n3] = dArray3[n3] / 2.0;
            }
            this.my_bullets.remove(rem);
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        VirtualBullet rem = null;
        for (VirtualBullet b : this.my_bullets) {
            if (e.getBullet() != b.bullet) continue;
            rem = b;
            break;
        }
        if (rem != null) {
            this.my_bullets.remove(rem);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        int n = this.enemy_fire_strategy;
        enemy_hit[n] = enemy_hit[n] + 1.0;
        double min_hit = enemy_hit[0] / enemy_fired[0];
        int new_enemy_fire_strategy = 0;
        int i = 1;
        while (i < 3) {
            double temp = enemy_fired[i] == 0.0 ? 0.0 : enemy_hit[i] / enemy_fired[i];
            if (min_hit > temp) {
                min_hit = temp;
                new_enemy_fire_strategy = i;
            }
            ++i;
        }
        this.enemy_fire_strategy = new_enemy_fire_strategy;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.target.alive = false;
    }

    private Point2D.Double LinearPrediction(Point2D.Double p1, Point2D.Double p2, double heading, double speed, double bullet_power) {
        double deltaTime = 1.0;
        Point2D.Double predicted = new Point2D.Double(p2.x, p2.y);
        while (deltaTime * (20.0 - 3.0 * bullet_power) < p1.distance(predicted) && deltaTime < 1000.0) {
            deltaTime += 1.0;
            predicted = T100.project(predicted, heading, speed);
            predicted.x = Math.min(Math.max(18.0, predicted.x), this.W - 18.0);
            predicted.y = Math.min(Math.max(18.0, predicted.y), this.H - 18.0);
        }
        return predicted;
    }

    private Point2D.Double RadialPrediction(Point2D.Double p1, Point2D.Double p2, double newheading, double oldheading, double speed, double bullet_power) {
        double deltaTime = 1.0;
        Point2D.Double predicted = new Point2D.Double(p2.x, p2.y);
        double deltaEnemyHeading = Utils.normalRelativeAngle((double)(newheading - oldheading));
        double predictedHeading = newheading;
        while (deltaTime * (20.0 - 3.0 * bullet_power) < p1.distance(predicted) && deltaTime < 1000.0) {
            deltaTime += 1.0;
            Point2D.Double newPredicted = T100.project(predicted, predictedHeading += deltaEnemyHeading, speed);
            newPredicted.x = Math.min(Math.max(18.0, newPredicted.x), this.W - 18.0);
            newPredicted.y = Math.min(Math.max(18.0, newPredicted.y), this.H - 18.0);
            predicted = newPredicted;
        }
        return predicted;
    }

    public static Point2D.Double project(Point2D.Double origin, double angle, double distance) {
        return new Point2D.Double(origin.x + distance * Math.sin(angle), origin.y + distance * Math.cos(angle));
    }

    public static double angle(Point2D.Double origin, Point2D.Double destination) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(destination.x - origin.x, destination.y - origin.y));
    }

    public double getRange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getRange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

