/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import xander.core.math.LinearEquation;
import xander.core.track.Wave;

public class DistancingEquation {
    public static final DistancingEquation NO_ADJUST = new DistancingEquation(0.0, 100.0, 200.0, 0.0, 0.0);
    private LinearEquation retreatEquation;
    private LinearEquation advanceEquation;
    private double optimalDistance;
    private double maxRetreatDistance;
    private double maxRetreatAngle;
    private double maxAdvanceAngle;

    public DistancingEquation(double maxRetreatDistance, double optimalDistance, double maxAdvanceDistance, double maxRetreatAngle, double maxAdvanceAngle) {
        this.setDistancing(maxRetreatDistance, optimalDistance, maxAdvanceDistance, maxRetreatAngle, maxAdvanceAngle);
    }

    public void setDistancing(double maxRetreatDistance, double optimalDistance, double maxAdvanceDistance, double maxRetreatAngle, double maxAdvanceAngle) {
        this.optimalDistance = optimalDistance;
        this.maxRetreatDistance = maxRetreatDistance;
        this.maxAdvanceAngle = maxAdvanceAngle;
        this.maxRetreatAngle = maxRetreatAngle;
        this.retreatEquation = new LinearEquation(maxRetreatDistance, maxRetreatAngle, optimalDistance, 0.0, 0.0, maxRetreatAngle);
        this.advanceEquation = new LinearEquation(optimalDistance, 0.0, maxAdvanceDistance, -maxAdvanceAngle, -maxAdvanceAngle, 0.0);
    }

    public double getMaxRetreatDistance() {
        return this.maxRetreatDistance;
    }

    public double getOptimalDistance() {
        return this.optimalDistance;
    }

    public double getMaxRetreatAngle() {
        return this.maxRetreatAngle;
    }

    public double getMaxAdvanceAngle() {
        return this.maxAdvanceAngle;
    }

    public double getAdjustAngle(double distance, Wave wave) {
        if (distance < this.optimalDistance) {
            return this.retreatEquation.getY(distance);
        }
        return this.advanceEquation.getY(distance);
    }
}

