/*
 * Decompiled with CFR 0.152.
 */
package tcf;

import tcf.AbstractPredictor;
import tcf.PredState;
import tcf.Prediction;
import tcf.StaticStore;

class SimpleGfPredictor
extends AbstractPredictor {
    Prediction m_prediction = new Prediction();
    double m_total = 0.0;
    double m_max = 0.0;
    double m_gain = 1.0;
    double m_nextIncr = 1.0;

    SimpleGfPredictor(String string, double d) {
        if (StaticStore.get("SimpleGfPredictor:" + string) != null) {
            this.m_prediction = (Prediction)StaticStore.get("SimpleGfPredictor:" + string);
        } else {
            StaticStore.put("SimpleGfPredictor:" + string, this.m_prediction);
        }
        this.m_gain = d;
    }

    public Object predict(PredState predState, Prediction prediction) {
        double d = this.m_total > 0.0 ? 1.0 / this.m_total : 1.0;
        for (int i = 0; i < 101; ++i) {
            prediction.set(i, this.m_prediction.get(i) * d);
        }
        return null;
    }

    public void learn(PredState predState, PredState predState2, Object object, double d, boolean bl) {
        if (!bl) {
            return;
        }
        this.m_prediction.addGf(d, this.m_nextIncr);
        this.m_total += this.m_nextIncr;
        this.m_nextIncr *= this.m_gain;
        if (this.m_total > 1.0E10) {
            this.m_prediction.scale(1.0 / this.m_total);
            this.m_total = 1.0;
            this.m_nextIncr = this.m_gain;
        }
        this.m_max = this.m_prediction.maxValue();
    }

    public void complexLearn(PredState predState, PredState predState2, Object object, double d, boolean bl) {
        int n = Prediction.gfToIndex(d);
        Prediction prediction = new Prediction();
        for (int i = 0; i < 101; ++i) {
            double d2 = (double)(n - i) / 3.0;
            prediction.set(i, 1.0 / (1.0 + d2 * d2));
        }
        if (!bl) {
            return;
        }
        this.m_prediction.accumulate(prediction, this.m_nextIncr);
        this.m_total = this.m_prediction.totalValue();
        this.m_nextIncr *= this.m_gain;
        if (this.m_nextIncr > 1.0E10) {
            this.m_prediction.scale(1.0 / this.m_total);
            this.m_total = this.m_prediction.totalValue();
            this.m_nextIncr = this.m_gain;
        }
        this.m_max = this.m_prediction.maxValue();
    }
}

