/*
 * Decompiled with CFR 0.152.
 */
package rjw.util;

import java.awt.geom.Point2D;
import rjw.pluggablerobot.Math2;
import robocode.util.Utils;

public class Vector {
    public double t;
    public double d;
    private Point2D.Double _point;

    public static Vector add(Vector ... vectors) {
        Point2D.Double p = null;
        Vector[] vectorArray = vectors;
        int n = vectors.length;
        int n2 = 0;
        while (n2 < n) {
            Vector vector = vectorArray[n2];
            if (vector != null) {
                p = p == null ? vector.getPoint() : Math2.add(p, vector.getPoint());
            }
            ++n2;
        }
        return p != null ? new Vector(p) : null;
    }

    public Vector(Point2D.Double point) {
        this.t = Math.atan2(point.getX(), point.getY());
        this.d = point.distance(0.0, 0.0);
    }

    public Vector(Point2D.Double origin, Point2D.Double target) {
        this(Math2.subtract(target, origin));
    }

    public Vector(double t, double d) {
        this.t = Utils.normalAbsoluteAngle((double)t);
        this.d = d;
    }

    public Point2D.Double getPoint() {
        if (this._point == null) {
            this._point = new Point2D.Double(this.d * Math.sin(this.t), this.d * Math.cos(this.t));
        }
        return this._point;
    }

    public Point2D.Double translate(Point2D.Double point) {
        return Math2.add(this.getPoint(), point);
    }

    public Vector add(Vector vector) {
        return new Vector(Math2.add(this.getPoint(), vector.getPoint()));
    }

    public Vector add(double dt) {
        return new Vector(this.t + dt, this.d);
    }

    public Vector subtract(Vector vector) {
        return new Vector(Math2.subtract(this.getPoint(), vector.getPoint()));
    }

    public Vector multiply(double factor) {
        return new Vector(this.t, this.d * factor);
    }

    public double t() {
        return this.t;
    }

    public double d() {
        return this.d;
    }
}

