/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun;

import florent.XSeries.gun.GunStrategy;
import florent.XSeries.gun.TargetSelector;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import robocode.Bullet;
import robocode.util.Utils;

public class FatalityGun
extends GunStrategy {
    private Xmen me;
    private Line2D.Double lineOfFire;
    private double hitTime = -1.0;
    private int chaseNumber;

    public FatalityGun(Xmen me) {
        this.me = me;
        this.selector = TargetSelector.getInstance(me, Tracker.getInstance());
        this.chaseNumber = 0;
    }

    public void onMainLoop() {
        boolean chase = false;
        Enemy target = this.selector.getTarget();
        if (target == null) {
            return;
        }
        if (!this.holdFire) {
            double firePower = -1.0;
            if (this.hitTime == -1.0) {
                this.chaseNumber = 1;
                firePower = Math.min(this.me.getEnergy() / 3.0, 3.0);
                this.hitTime = (double)this.me.getTime() + target.distance / RobocodeTools.bulletVelocity(firePower);
            } else {
                double fireVelocty = target.distance / (this.hitTime - (double)this.me.getTime());
                firePower = RobocodeTools.bulletPower(fireVelocty);
                if (firePower > 0.0 && firePower <= 3.0) {
                    chase = true;
                } else {
                    firePower = Math.min(this.me.getEnergy() / 3.0, 3.0);
                    this.hitTime = (double)this.me.getTime() + target.distance / RobocodeTools.bulletVelocity(firePower);
                    this.chaseNumber = 1;
                }
            }
            if (firePower + 1.0 > this.me.getEnergy()) {
                return;
            }
            Bullet bullet = null;
            if (this.me.getGunTurnRemainingRadians() == 0.0 && !this.holdFire && firePower > 0.0 && this.hitTime > 0.0) {
                bullet = this.me.setFireBullet(firePower);
            }
            if (bullet != null && chase) {
                ++this.chaseNumber;
            }
        }
        Point2D.Double targetLocation = new Point2D.Double(target.location.x, target.location.y);
        targetLocation = RobocodeTools.projectMotion(targetLocation, target.heading, target.timeSinceScan * target.velocity);
        double enemyAbsoluteBearing = RobocodeTools.absoluteBearing(new Point2D.Double(this.me.getX(), this.me.getY()), targetLocation);
        this.lineOfFire = new Line2D.Double(new Point2D.Double(targetLocation.x, this.me.getBattleFieldHeight() - targetLocation.y), new Point2D.Double(this.me.getX(), this.me.getBattleFieldHeight() - this.me.getY()));
        this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.me.getGunHeadingRadians())));
    }

    public void onPaint(Graphics2D e) {
        e.setColor(Color.GRAY);
        e.draw(this.lineOfFire);
        this.selector.onPaint(e);
    }

    public void initRound() {
        this.hitTime = -1.0;
    }
}

