/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun.virtual;

import florent.XSeries.Configuration;
import florent.XSeries.gun.PatternMatchingGun;
import florent.XSeries.radar.Enemy;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import florent.XSeries.utils.VisitRecorder;
import florent.XSeries.utils.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class GunWave
extends Wave {
    public static PatternMatchingGun pmGun;
    private static long time;
    private static final int ANGLES = 2;
    public double[] angles = new double[2];
    private Enemy enemy;

    public GunWave(Enemy enemy, double angle1, double angle2, double diff1, double diff2) {
        this.angles[0] = angle1;
        this.angles[1] = angle2;
        if (diff1 < 1000.0) {
            enemy.data.VGdiffs[0] = 0.9 * enemy.data.VGdiffs[0] + 0.1 * diff1;
        }
        if (diff2 < 1000.0) {
            enemy.data.VGdiffs[1] = 0.9 * enemy.data.VGdiffs[1] + 0.1 * diff2;
        }
        this.enemy = enemy;
    }

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double fireTime) {
        super.init(gun, target, bearingDirection, power, fireTime);
        Configuration.me.addCustomEvent(this);
    }

    protected Point2D.Double getTargetLocation() {
        return this.enemy.location;
    }

    protected VisitRecorder getRecorder() {
        return null;
    }

    public boolean test() {
        this.synch();
        if (this.passed(this.velocity * 1.5, time, this.enemy.location)) {
            double goodAngle = Utils.normalRelativeAngle((double)(RobocodeTools.absoluteBearing(this.gunLocation, this.getTargetLocation()) - RobocodeTools.absoluteBearing(this.gunLocation, this.startLocation)));
            if (Configuration.me.getOthers() > 0) {
                int i = 0;
                while (i < 2) {
                    if (this.hit(goodAngle, this.angles[i])) {
                        int n = i;
                        this.enemy.data.VGhits[n] = this.enemy.data.VGhits[n] + 1.0;
                        this.enemy.data.VGrating[i] = RobocodeTools.rollingAverage(Math.min(500, this.enemy.data.myBulletsFired), this.enemy.data.VGrating[i], 100.0);
                    } else {
                        this.enemy.data.VGrating[i] = RobocodeTools.rollingAverage(Math.min(500, this.enemy.data.myBulletsFired), this.enemy.data.VGrating[i], 0.0);
                    }
                    ++i;
                }
            }
            Configuration.me.removeCustomEvent(this);
            GunWave.pmGun.waves.remove((Object)this);
        }
        return false;
    }

    private void synch() {
        time = Configuration.me.getTime();
    }

    private boolean hit(double goodAngle, double angle) {
        return Math.abs(Utils.normalRelativeAngle((double)(goodAngle - angle))) < Math.asin(20.0 / this.gunLocation.distance(this.enemy.location));
    }

    public void onPaint(Graphics2D g) {
        this.synch();
        int radius = (int)(this.velocity * ((double)time - this.fireTime));
        g.setColor(Color.green);
        g.drawOval((int)(this.gunLocation.x - (double)radius), (int)(Configuration.battleFieldHeigth - this.gunLocation.y - (double)radius), 2 * radius, 2 * radius);
        Force force = new Force(new Point2D.Double(this.gunLocation.x, this.gunLocation.y), new Point2D.Double(this.enemy.location.x, this.enemy.location.y));
        double tolerance = Math.asin(20.0 / this.gunLocation.distance(this.enemy.location));
        force.rotate(tolerance);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
        force.rotate(-2.0 * tolerance);
        g.drawLine((int)force.origin.x, (int)(Configuration.battleFieldHeigth - force.origin.y), (int)force.end.x, (int)(Configuration.battleFieldHeigth - force.end.y));
    }
}

