/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.Log;
import pa3k.Position;
import pa3k.RobotModule;
import robocode.AdvancedRobot;
import robocode.Robot;
import robocode.Rules;
import robocode.util.Utils;

public class SelfTracking
extends RobotModule {
    protected int history;
    protected int index;
    protected Position[] lastPosition;
    protected double[] lastVelocity;
    protected double[] lastHeading;
    protected int energyIndex;
    protected long[] lastEnergyDropTime;
    protected double lastEnergy;

    public SelfTracking(AdvancedRobot robot, int history) {
        super(robot);
        this.history = history;
        this.index = 0;
        this.lastPosition = new Position[history];
        this.lastVelocity = new double[history];
        this.lastHeading = new double[history];
        this.lastEnergyDropTime = new long[history];
        this.energyIndex = 0;
    }

    @Override
    public void init() {
        int i = 0;
        while (i < this.history) {
            this.lastPosition[i] = new Position((Robot)this.robot);
            this.lastVelocity[i] = this.robot.getVelocity();
            this.lastHeading[i] = this.robot.getHeadingRadians();
            ++i;
        }
        this.lastEnergy = this.robot.getEnergy();
    }

    @Override
    public void turn() {
        ++this.index;
        this.index %= this.history;
        this.lastPosition[this.index] = new Position((Robot)this.robot);
        this.lastVelocity[this.index] = this.robot.getVelocity();
        this.lastHeading[this.index] = this.robot.getHeadingRadians();
        double e = this.robot.getEnergy();
        if (e < this.lastEnergy) {
            ++this.energyIndex;
            this.energyIndex %= this.history;
            this.lastEnergyDropTime[this.energyIndex] = this.robot.getTime();
        }
        this.lastEnergy = e;
    }

    public Position getLastPosition(int i) throws Exception {
        return this.lastPosition[this.getLastIndex(i)];
    }

    public double getLastVelocity(int i) throws Exception {
        return this.lastVelocity[this.getLastIndex(i)];
    }

    public double getLastHeading(int i) throws Exception {
        return this.lastHeading[this.getLastIndex(i)];
    }

    private int getLastIndex(int i) throws Exception {
        if (i > this.history) {
            throw new Exception();
        }
        return (this.index + this.history - i) % this.history;
    }

    public Position projectPosition(Position bulletSource, double bulletVelocity, int timeOffset) {
        Position r = null;
        double origVelocity = 0.0;
        double heading = 0.0;
        double dHeading = 0.0;
        try {
            r = new Position(this.getLastPosition(0));
            origVelocity = this.getLastVelocity(0);
            heading = this.getLastHeading(0);
            dHeading = this.getLastHeading(0) - this.getLastHeading(1);
        }
        catch (Exception e) {
            Thread.dumpStack();
            return r;
        }
        double velocity = origVelocity;
        double dVelocity = origVelocity;
        int direction = 1;
        if (velocity > 0.0 && dVelocity < 0.0) {
            direction = -1;
        }
        if (velocity < 0.0 && dVelocity > 0.0) {
            direction = -1;
        }
        int i = 0;
        while ((double)i < bulletSource.distance(r) / bulletVelocity - 1.0 - (double)timeOffset) {
            velocity = direction == 1 ? (origVelocity >= 0.0 ? (velocity += 1.0) : (velocity -= 1.0)) : (origVelocity >= 0.0 ? (velocity > 0.0 ? (velocity -= 2.0) : (velocity -= 1.0)) : (velocity < 0.0 ? (velocity += 2.0) : (velocity += 1.0)));
            if (velocity > 8.0) {
                velocity = 8.0;
            } else if (velocity < -8.0) {
                velocity = -8.0;
            }
            if (velocity != 0.0) {
                Position prev = new Position(r);
                r.check();
                r.modify(1L, velocity, heading);
                r.adjustForWalls(prev, 1, null, 0.0, velocity < 0.0 ? Utils.normalAbsoluteAngle((double)(heading + Math.PI)) : heading);
                r.check();
            }
            Log.paintPoint(3, r, Color.WHITE);
            double maxTurnRate = Math.abs(Rules.getTurnRateRadians((double)Math.abs(velocity)));
            if (dHeading > maxTurnRate) {
                dHeading = maxTurnRate;
            }
            if (dHeading < -maxTurnRate) {
                dHeading = -maxTurnRate;
            }
            heading = Utils.normalAbsoluteAngle((double)(heading + dHeading));
            ++i;
        }
        r.check();
        return r;
    }

    public long lastEnergyDrop(long l) {
        return l - this.lastEnergyDropTime[this.energyIndex];
    }
}

