/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.awt.Color;
import pa3k.AngleUtils;
import pa3k.BulletTracking;
import pa3k.CalendarMoving;
import pa3k.CalendarMovingTask;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.TaskExecutor;
import pa3k.Tracking;
import robocode.AdvancedRobot;
import robocode.Robot;

public class WaveSurfing
extends CalendarMoving
implements TaskExecutor {
    protected BulletTracking wave = null;

    public WaveSurfing(AdvancedRobot robot, Tracking tracking) {
        super(robot, tracking);
    }

    @Override
    public void turn() {
        Position myPos = new Position((Robot)this.robot);
        BulletTracking b = this.tracking.getClosestBullet();
        if (b != this.wave && b != null) {
            this.wave = b;
            long t = this.robot.getTime();
            double[] bins = this.wave.getEscapeBins();
            int i = 0;
            while (i < bins.length) {
                Log.log(4, "Escape bins: " + i + ": " + bins[i]);
                ++i;
            }
            Opponent owner = this.wave.getOwner();
            long timeDelta = this.wave.getETA(myPos) - t - 2L;
            double distance = myPos.distance(owner.getLastPosition());
            double angle = owner.getLastPosition().getDirectionTo(myPos);
            double positiveProjection = myPos.projectAngle(timeDelta, 8.0, this.robot.getVelocity(), owner, 0, false);
            double negativeProjection = myPos.projectAngle(timeDelta, 8.0, this.robot.getVelocity(), owner, 1, false);
            double stopProjection = myPos.projectAngle(timeDelta, 0.0, this.robot.getVelocity(), owner, 0, false);
            double positiveProjectionS = myPos.projectAngle(timeDelta, 8.0, this.robot.getVelocity(), owner, 0, true);
            double negativeProjectionS = myPos.projectAngle(timeDelta, 8.0, this.robot.getVelocity(), owner, 1, true);
            Position[] escapes = new Position[5];
            int i2 = 0;
            while (i2 < escapes.length) {
                escapes[i2] = new Position(this.wave.getOwner().getLastPosition());
                ++i2;
            }
            int swap = 1;
            if (this.direction == -1 && this.robot.getVelocity() == 0.0) {
                swap = -1;
            }
            escapes[0].modify(swap, distance, angle + positiveProjection);
            escapes[1].modify(swap, distance, angle + negativeProjection);
            escapes[2].modify(1L, distance, angle + stopProjection);
            escapes[3].modify(swap, distance, angle + positiveProjectionS);
            escapes[4].modify(swap, distance, angle + negativeProjectionS);
            double adv = this.wave.getAngleAdvance();
            int choices = escapes.length;
            choices = bins.length >= 12 ? escapes.length : (bins.length >= 6 ? 3 : 2);
            int[] idx = new int[choices];
            int i3 = 0;
            while (i3 < idx.length) {
                idx[i3] = (int)(AngleUtils.difference(this.wave.getSource().getDirectionTo(escapes[i3]), this.wave.getNegativeAngle() - adv / 2.0) / adv);
                if (idx[i3] < 0) {
                    idx[i3] = 0;
                }
                if (idx[i3] >= bins.length) {
                    idx[i3] = bins.length - 1;
                }
                Log.log(3, "Wave surfing escpe " + i3 + " = bin " + idx[i3] + " (" + bins[idx[i3]] + ")");
                ++i3;
            }
            int low = 0;
            int i4 = 1;
            while (i4 < idx.length) {
                if (bins[idx[i4]] <= bins[idx[low]]) {
                    low = i4;
                }
                Log.paintPoint(2, escapes[i4], Color.RED, 2);
                ++i4;
            }
            Log.paintPoint(2, escapes[low], Color.BLACK, 4);
            switch (low) {
                case 0: {
                    this.setMaxSpeed(8.0);
                    Log.log(3, "Full speed ahead");
                    break;
                }
                case 1: {
                    this.setMaxSpeed(8.0);
                    this.direction *= -1;
                    Log.log(3, "Full speed backwards");
                    break;
                }
                case 2: {
                    this.setMaxSpeed(0.0);
                    Log.log(3, "Stop");
                    break;
                }
                case 3: {
                    this.setMovingBudget(myPos.distance(escapes[low]));
                    Log.log(3, "Farward with stop");
                    break;
                }
                case 4: {
                    this.setMovingBudget(myPos.distance(escapes[low]));
                    this.direction *= -1;
                    Log.log(3, "Backward with stop");
                }
            }
            this.setPivot(new Position(owner.getLastPosition()));
        }
        if (this.wave != null && this.wave.getEvaded()) {
            this.setPivot(null);
        }
        super.turn();
    }

    @Override
    public void execute(CalendarMoving m, CalendarMovingTask t) {
        this.direction *= -1;
    }
}

