/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.mega.index;

import lazarecki.mega.index.Index;
import lazarecki.robot.ModularRobot;
import lazarecki.robot.RobotInfo;
import robocode.Rules;

public class LastVelocityChangeIndex
implements Index {
    private ModularRobot robot;
    private boolean invert;
    private double lastEnemyVelocity;
    private long lastEnemyVelocityTime;

    public LastVelocityChangeIndex(ModularRobot robot, boolean invert) {
        this.robot = robot;
        this.invert = invert;
    }

    public ModularRobot getRobot() {
        return this.robot;
    }

    public void setRobot(ModularRobot robot) {
        this.robot = robot;
    }

    @Override
    public String getName() {
        return "LastVelocityChange";
    }

    @Override
    public int getSegmentIndex(RobotInfo me, RobotInfo enemy) {
        double time;
        if (!this.invert) {
            if (Math.abs(enemy.getVelocity()) != this.lastEnemyVelocity) {
                this.lastEnemyVelocity = Math.abs(enemy.getVelocity());
                this.lastEnemyVelocityTime = enemy.getTime();
            }
            if (this.getRobot().getFirePower() == 0.0) {
                return 0;
            }
            double time2 = (double)(enemy.getTime() - this.lastEnemyVelocityTime) / (me.distance(enemy) / Rules.getBulletSpeed((double)this.getRobot().getFirePower()));
            if (time2 < 0.1) {
                return 0;
            }
            if (time2 < 0.3) {
                return 1;
            }
            if (time2 < 1.0) {
                return 2;
            }
            return 3;
        }
        if (Math.abs(me.getVelocity()) != this.lastEnemyVelocity) {
            this.lastEnemyVelocity = Math.abs(me.getVelocity());
            this.lastEnemyVelocityTime = me.getTime();
        }
        if ((time = (double)(me.getTime() - this.lastEnemyVelocityTime) / (enemy.distance(me) / Rules.getBulletSpeed((double)1.7))) < 0.1) {
            return 0;
        }
        if (time < 0.3) {
            return 1;
        }
        if (time < 1.0) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getSegments() {
        return 4;
    }
}

