/*
 * Decompiled with CFR 0.152.
 */
package ds;

import ds.Math2;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import robocode.Robot;

public class Hud {
    private Graphics2D _g;
    private Color _color;
    public double _w;
    public double _h;

    public Hud(Robot bot) {
        this._w = bot.getBattleFieldWidth();
        this._h = bot.getBattleFieldHeight();
        this._color = Color.white;
    }

    public void setColor(Color c) {
        this._color = c;
    }

    public void drawPoint(double x, double y) {
        int x0 = this.i(x);
        int y0 = this.i(y);
        this._g.setColor(this._color);
        this._g.drawLine(x0, y0, x0, y0);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this._g.setColor(this._color);
        this._g.drawLine(this.i(x1), this.i(y1), this.i(x2), this.i(y2));
    }

    public void drawCircle(double x, double y, double r) {
        int d = this.i(r * 2.0);
        this._g.setColor(this._color);
        this._g.drawOval(this.i(x - r), this.i(y - r), d, d);
    }

    public void drawFilledCircle(double x, double y, double r) {
        int d = this.i(r * 2.0);
        this._g.setColor(this._color);
        this._g.fillOval(this.i(x - r), this.i(y - r), d, d);
    }

    public void drawArc(double x, double y, double r, double start, double extend) {
        int d = this.i(r * 2.0);
        this._g.setColor(this._color);
        this._g.drawArc(this.i(x - r), this.i(y - r), d, d, this.i(Math2.radToDeg(start)), this.i(Math2.radToDeg(extend)));
    }

    public void drawRect(double x, double y, double w, double h) {
        this._g.setColor(this._color);
        this._g.drawRect(this.i(x), this.i(y), this.i(w), this.i(h));
    }

    public void drawFilledRect(double x, double y, double w, double h) {
        this._g.setColor(this._color);
        this._g.fillRect(this.i(x), this.i(y), this.i(w), this.i(h));
    }

    public void drawString(String s, double x, double y) {
        this._g.setColor(this._color);
        this._g.drawString(s, this.i(x), this.i(y));
    }

    public void drawStringRight(String s, double x, double y) {
        this._g.setColor(this._color);
        this._g.drawString(s, this.i(x) - this._g.getFontMetrics().stringWidth(s), this.i(y));
    }

    public void setPaint(Paint c) {
        this._g.setColor(this._color);
        this._g.setPaint(c);
    }

    public double getWidth() {
        return this._w;
    }

    public double getHeight() {
        return this._h;
    }

    public void setContext(Graphics2D g) {
        this._g = g;
    }

    private int i(double val) {
        return (int)Math.round(val);
    }

    public static interface Painter {
        public void paint(Hud var1, long var2);
    }
}

