/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.dsgf;

import ds.Hud;
import ds.constant.ConstantManager;
import ds.gun.AbstractGun;
import ds.gun.BulletPower;
import ds.gun.BulletWave;
import ds.gun.FireSolution;
import ds.gun.IDataSaver;
import ds.gun.IVirtualBullet;
import ds.gun.VirtualBullet;
import ds.gun.dsgf.FireIndex;
import ds.gun.dsgf.IndexedVirtualBullet;
import ds.gun.dsgf.SegmentationInfo;
import ds.gun.dsgf.Tree;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class DSGFGun
extends AbstractGun
implements IDataSaver {
    private Tree m_tree;
    private BulletWave m_lastWave;
    private ArrayList<BulletWave> m_waves;
    private int m_nbSamples;
    private int m_flood;
    private double m_lastPower;
    private SegmentationInfo m_lastSi;

    public DSGFGun(String specialisation, AdvancedRobot owner, ITargetManager targetManager, boolean bIsDataSaver) {
        super("dsgf" + specialisation, owner, targetManager, Color.orange);
        ConstantManager cm = ConstantManager.getInstance();
        int maxNodeLeafCount = (int)cm.getIntegerConstant("gun.dsgf" + specialisation + ".maxNodeLeafCount").longValue();
        int minNodeLeafCount = (int)cm.getIntegerConstant("gun.dsgf" + specialisation + ".minNodeLeafCount").longValue();
        this.m_flood = (int)cm.getIntegerConstant("gun.dsgf" + specialisation + ".flood").longValue();
        double decayFactor = cm.getDoubleConstant("gun.dsgf" + specialisation + ".decayFactor");
        this.m_tree = new Tree(maxNodeLeafCount, minNodeLeafCount, bIsDataSaver, decayFactor);
        this.m_waves = new ArrayList();
        this.m_lastWave = null;
        this.m_nbSamples = (int)ConstantManager.getInstance().getIntegerConstant("gun.dsgf.nbSamples").longValue();
    }

    @Override
    public void Act(double power) {
        IVirtualBot target;
        this.m_lastPower = power;
        try {
            target = this.getTargetManager().getCurrentTarget();
            if (this.getOwner().getEnergy() > 0.1) {
                this.fireWave(target, power);
            }
        }
        catch (TargetException targetException) {
            // empty catch block
        }
        for (BulletWave wave : this.m_waves) {
            wave.update();
        }
        Iterator<BulletWave> itBW = this.m_waves.iterator();
        while (itBW.hasNext()) {
            BulletWave wave = itBW.next();
            VirtualBullet vb = wave.getBullets().get(0);
            try {
                target = this.getTargetManager().getCurrentTarget();
                if (!(vb.travelDistance() - 30.0 > vb.getStartPosition().distance(target.getPosition()))) continue;
                itBW.remove();
            }
            catch (TargetException e) {
                itBW.remove();
            }
        }
        for (BulletWave wave : this.m_waves) {
            for (VirtualBullet vb : wave.getBullets()) {
                try {
                    target = this.getTargetManager().getCurrentTarget();
                    if (!(vb.getCurrentPosition().distance(target.getPosition()) < target.getSize() / 2.0)) continue;
                    if (!(vb.hasHit() || this.m_flood > 0 && wave.estReelle())) {
                        this.m_tree.add((IndexedVirtualBullet)vb);
                    }
                    vb.setHit(true);
                }
                catch (TargetException targetException) {
                    // empty catch block
                }
            }
        }
    }

    private void fireWave(IVirtualBot target, double power, boolean bReelle) {
        if (this.m_flood == 0 && !bReelle) {
            return;
        }
        if (this.m_lastWave == null || this.m_lastWave.getLaunchTurn() <= this.getOwner().getTime() - (long)this.m_flood || this.m_lastWave.getLaunchRound() < (long)this.getOwner().getRoundNum() || bReelle || this.m_lastWave.getLaunchTurn() == this.getOwner().getTime() && this.m_lastWave.getLaunchRound() == (long)this.getOwner().getRoundNum()) {
            SegmentationInfo si;
            BulletWave bw = new BulletWave(this.getOwner().getRoundNum(), this.getOwner().getTime(), bReelle);
            this.m_waves.add(bw);
            this.m_lastWave = bw;
            double maxEscapeAngle = Math.asin(8.0 / (20.0 - 3.0 * power));
            this.m_lastSi = si = new SegmentationInfo(this.getOwner(), target, power);
            double[] hitChances = this.m_tree.getSolutionSamples(si);
            int i = 0;
            while (i < this.m_nbSamples) {
                int angleIndex = i;
                IndexedVirtualBullet ivb = new IndexedVirtualBullet(target, this, new Point2D.Double(this.getOwner().getX(), this.getOwner().getY()), angleIndex, power, maxEscapeAngle, hitChances[i]);
                this.m_lastWave.addBullet(ivb);
                ++i;
            }
        }
    }

    private void fireWave(IVirtualBot target, double power) {
        double[] dArray = BulletPower.getPowerLevels();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double powerLvl = dArray[n2];
            this.fireWave(target, powerLvl, false);
            ++n2;
        }
    }

    @Override
    protected FireSolution computeFireSolution(double bulletPower) {
        double fiabilite = 0.0;
        double angle = 0.0;
        try {
            IVirtualBot target = this.getTargetManager().getCurrentTarget();
            SegmentationInfo si = new SegmentationInfo(this.getOwner(), target, bulletPower);
            FireIndex solutionIndex = this.m_tree.getSolution(si);
            double relativeSolutionIndex = solutionIndex.getRelativeAngleIndex();
            double maxEscapeAngle = Math.asin(8.0 / (20.0 - 3.0 * bulletPower));
            double step = 1.0 / (double)this.m_nbSamples;
            angle = target.getLateralDirection() * relativeSolutionIndex * step * maxEscapeAngle;
            angle = Utils.normalRelativeAngle((double)(angle + target.getAbsoluteBearingRadians() - this.getOwner().getGunHeadingRadians()));
            fiabilite = solutionIndex.getFiabilite();
        }
        catch (TargetException targetException) {
            // empty catch block
        }
        return new FireSolution(angle, angle + this.getOwner().getGunHeadingRadians(), fiabilite);
    }

    @Override
    public void virtualFire(double power) {
        try {
            IVirtualBot target = this.getTargetManager().getCurrentTarget();
            this.fireWave(target, power, true);
        }
        catch (TargetException targetException) {
            // empty catch block
        }
    }

    @Override
    public void paint(Hud hud, long tick) {
        if (this.m_lastSi != null) {
            hud.setColor(Color.green);
            int i = 0;
            while (i < this.m_lastSi.getDImCount()) {
                String s = String.valueOf(SegmentationInfo.getDimensionName(i)) + ": " + this.m_lastSi.getInfo(i);
                hud.drawString(s, 500.0, 500 - i * 15);
                ++i;
            }
        }
        hud.setColor(Color.gray);
        for (BulletWave bw : this.m_waves) {
            for (IVirtualBullet iVirtualBullet : bw.getBullets()) {
                float blue = (float)((IndexedVirtualBullet)iVirtualBullet).getHitChance();
                if (iVirtualBullet.hasHit()) {
                    hud.setColor(Color.red);
                } else {
                    hud.setColor(new Color(0.0f, 0.0f, blue));
                }
                hud.drawFilledCircle(iVirtualBullet.getCurrentPosition().getX(), iVirtualBullet.getCurrentPosition().getY(), 3.0);
            }
        }
        try {
            hud.setColor(Color.red);
            IVirtualBot target = this.getTargetManager().getCurrentTarget();
            SegmentationInfo si = new SegmentationInfo(this.getOwner(), target, this.m_lastPower);
            Vector<String> vector = this.m_tree.getSolutionString(si);
            int i = 0;
            for (String s : vector) {
                if (i < 20) {
                    hud.drawString(s, 50.0, 500 - i * 15);
                }
                ++i;
            }
        }
        catch (TargetException targetException) {
            // empty catch block
        }
        this.m_tree.paint(hud, tick);
    }

    @Override
    public void save() {
    }
}

