/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.DynamicVelocity;
import pedersen.physics.StaticVelocity;
import pedersen.physics.StaticVelocityImpl;

public class DynamicVelocityImpl
implements DynamicVelocity {
    private double velocity;
    private double target;

    public DynamicVelocityImpl(double newVelocity) {
        this.setVelocity(newVelocity);
        this.setAbsoluteTargetVelocity(newVelocity);
    }

    public DynamicVelocityImpl(StaticVelocity newVelocity) {
        this.setVelocity(newVelocity.getVelocity());
        this.setAbsoluteTargetVelocity(newVelocity.getVelocity());
    }

    public StaticVelocity getStaticVelocity() {
        return new StaticVelocityImpl(this.velocity);
    }

    public void setVelocity(double newVelocity) {
        this.velocity = newVelocity;
    }

    public void setAbsoluteTargetVelocity(double newVelocity) {
        this.target = newVelocity;
    }

    public void setRelativeTargetVelocity(double other) {
        this.setAbsoluteTargetVelocity(this.velocity + other);
    }

    public double projectVelocity() {
        double relativeVelocity = DynamicVelocityImpl.getDeltaVelocity(this.velocity, this.target);
        double absoluteVelocity = StaticVelocityImpl.getCompoundVelocity(this.velocity, relativeVelocity);
        return Constraints.getClosestLegalValue(-8.0, absoluteVelocity, 8.0);
    }

    private static double getDeltaVelocity(double v, double t) {
        double deltaVelocity = 0.0;
        deltaVelocity = Constraints.isInRange(0.0, v, t) || Constraints.isInRange(t, v, 0.0) ? Constraints.getClosestLegalVehicularAcceleration(StaticVelocityImpl.getRelativeVelocity(v, t)) : Constraints.getClosestLegalVehicularDeceleration(StaticVelocityImpl.getRelativeVelocity(v, t));
        return deltaVelocity;
    }

    public void debug() {
        Debug.debug("Dynamic velocity: " + Debug.trim(this.velocity));
        Debug.debug("Target velocity: " + Debug.trim(this.target));
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getRelativeVelocity(double other) {
        return StaticVelocityImpl.getRelativeVelocity(this.velocity, other);
    }

    public double getCompoundVelocity(double other) {
        return StaticVelocityImpl.getCompoundVelocity(this.velocity, other);
    }
}

