/*
 * Decompiled with CFR 0.152.
 */
package xander.core.drive;

import java.awt.geom.Point2D;
import xander.core.RobotProxy;
import xander.core.track.Snapshot;

public class DriveState {
    Point2D.Double position;
    double heading;
    double velocity;
    long time;

    public DriveState() {
    }

    public DriveState(RobotProxy robotProxy) {
        this.position = new Point2D.Double(robotProxy.getX(), robotProxy.getY());
        this.velocity = robotProxy.getVelocity();
        this.heading = robotProxy.getHeadingDegrees();
        this.time = robotProxy.getTime();
    }

    public DriveState(Snapshot rs) {
        this.position = new Point2D.Double(rs.getX(), rs.getY());
        this.heading = rs.getHeadingRoboDegrees();
        this.velocity = rs.getVelocity();
        this.time = rs.getTime();
    }

    public DriveState(DriveState ds) {
        this.position = new Point2D.Double(ds.position.x, ds.position.y);
        this.heading = ds.heading;
        this.velocity = ds.velocity;
        this.time = ds.time;
    }

    public void setState(DriveState ds) {
        this.position = new Point2D.Double(ds.position.x, ds.position.y);
        this.heading = ds.heading;
        this.velocity = ds.velocity;
        this.time = ds.time;
    }

    public void setState(Snapshot rs) {
        this.position = new Point2D.Double(rs.getX(), rs.getY());
        this.heading = rs.getHeadingRoboDegrees();
        this.velocity = rs.getVelocity();
        this.time = rs.getTime();
    }

    public Point2D.Double getPosition() {
        return this.position;
    }

    public double getX() {
        return this.position.x;
    }

    public double getY() {
        return this.position.y;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public long getTime() {
        return this.time;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.heading);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        temp = Double.doubleToLongBits(this.velocity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DriveState other = (DriveState)obj;
        if (Double.doubleToLongBits(this.heading) != Double.doubleToLongBits(other.heading)) {
            return false;
        }
        if (this.position == null ? other.position != null : !this.position.equals(other.position)) {
            return false;
        }
        return Double.doubleToLongBits(this.velocity) == Double.doubleToLongBits(other.velocity);
    }
}

