/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.radar;

import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.RadarStrategy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class MeleeRadar
extends RadarStrategy {
    private Xmen me;
    private ArrayList<Enemy> scanned;
    private Tracker tracker;
    private int direction = 1;

    public MeleeRadar(Xmen me) {
        this.me = me;
    }

    public void initRound() {
        this.me.setTurnRadarRight(Double.POSITIVE_INFINITY);
        this.tracker = Tracker.getInstance();
        this.scanned = new ArrayList();
    }

    public void onMainLoop() {
        this.me.setTurnRadarRight((double)this.direction * Double.POSITIVE_INFINITY);
        for (Enemy enemy : this.scanned) {
            if (!((double)this.me.getTime() - enemy.lastScan > 18.0)) continue;
            this.scanned.remove(enemy.name);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.me.isTeammate(e.getName())) {
            return;
        }
        Enemy enemy = this.tracker.getEnemy(e.getName());
        if (!this.scanned.contains(enemy)) {
            this.scanned.add(enemy);
        }
        if (this.scanned.size() >= this.me.getEnmiesAlive()) {
            Point2D.Double myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
            Enemy first = null;
            Object last = null;
            double max = 0.0;
            for (Enemy en : this.scanned) {
                double bearing = RobocodeTools.absoluteBearing(myLocation, en.location);
                for (Enemy en2 : this.scanned) {
                    double res = Math.abs(Utils.normalRelativeAngle((double)(bearing - RobocodeTools.absoluteBearing(myLocation, en2.location))));
                    if (!(max < res)) continue;
                    max = res;
                    first = en;
                    last = en2;
                }
            }
            if (last != null && last.equals(enemy) && Utils.normalAbsoluteAngle((double)((double)this.direction * (RobocodeTools.absoluteBearing(myLocation, first.location) - RobocodeTools.absoluteBearing(myLocation, ((Enemy)last).location)))) > Math.PI) {
                this.direction *= -1;
                this.scanned.clear();
                this.scanned.add(enemy);
            } else {
                this.scanned.remove(enemy);
                this.scanned.add(enemy);
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        Enemy enemy = this.tracker.getEnemy(e.getName());
        this.scanned.remove(enemy);
    }
}

