/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.compound;

import dmonner.xlbp.Component;
import dmonner.xlbp.InputComponent;
import dmonner.xlbp.NetworkCopier;
import dmonner.xlbp.NetworkStringBuilder;
import dmonner.xlbp.WeightInitializer;
import dmonner.xlbp.WeightUpdaterType;
import dmonner.xlbp.compound.AbstractCompound;
import dmonner.xlbp.layer.AbstractLayer;
import dmonner.xlbp.layer.FanOutLayer;
import dmonner.xlbp.layer.InputLayer;
import dmonner.xlbp.layer.NoisyInputLayer;
import dmonner.xlbp.util.NoiseGenerator;
import java.util.ArrayList;

public class InputCompound
extends AbstractCompound
implements InputComponent {
    private static final long serialVersionUID = 1L;
    private final InputLayer input;
    private FanOutLayer fan;
    private boolean responsible;

    public InputCompound(InputCompound that, NetworkCopier copier) {
        super(that, copier);
        this.input = copier.getCopyOf(that.input);
        this.fan = copier.getCopyOf(that.fan);
        this.out = copier.getCopyOf(that.out);
    }

    public InputCompound(String name, int size) {
        this(name, size, null);
    }

    public InputCompound(String name, int size, NoiseGenerator noise) {
        super(name);
        this.input = noise == null ? new InputLayer(name + "Input", size) : new NoisyInputLayer(name + "NoisyInput", size, noise);
        this.fan = new FanOutLayer(name + "Fanout", size);
        this.fan.addUpstream(this.input);
        this.out = this.fan;
    }

    @Override
    public void activateTest() {
    }

    @Override
    public void activateTrain() {
    }

    @Override
    public void build() {
        if (!this.built) {
            this.input.build();
            if (this.fan != null) {
                this.fan.build();
            }
            this.built = true;
        }
    }

    @Override
    public void clearActivations() {
        this.input.clearActivations();
    }

    @Override
    public void clearEligibilities() {
    }

    @Override
    public void clearResponsibilities() {
        if (this.responsible && this.fan != null) {
            this.fan.clearResponsibilities();
        }
    }

    @Override
    public InputCompound copy(NetworkCopier copier) {
        return new InputCompound(this, copier);
    }

    @Override
    public InputCompound copy(String nameSuffix) {
        NetworkCopier copier = new NetworkCopier(nameSuffix);
        InputCompound copy = this.copy(copier);
        copier.build();
        return copy;
    }

    @Override
    public Component[] getComponents() {
        ArrayList<AbstractLayer> list = new ArrayList<AbstractLayer>();
        list.add(this.input);
        if (this.fan != null) {
            list.add(this.fan);
        }
        return list.toArray(new Component[list.size()]);
    }

    public InputLayer getInputLayer() {
        return this.input;
    }

    @Override
    public int nWeights() {
        return 0;
    }

    @Override
    public boolean optimize() {
        if (!super.optimize()) {
            return false;
        }
        this.input.optimize();
        if (this.fan != null && !this.fan.optimize()) {
            this.out = this.input;
            this.fan = null;
        }
        return true;
    }

    @Override
    public void processBatch() {
    }

    @Override
    public void setInput(float[] activations) {
        this.input.setInput(activations);
    }

    public void setResponsible(boolean responsible) {
        this.responsible = responsible;
    }

    @Override
    public void setWeightInitializer(WeightInitializer win) {
    }

    @Override
    public void setWeightUpdaterType(WeightUpdaterType wut) {
    }

    @Override
    public void toString(NetworkStringBuilder sb) {
        if (sb.showIntermediate()) {
            super.toString(sb);
            sb.pushIndent();
            if (this.fan != null) {
                this.fan.toString(sb);
            }
            this.input.toString(sb);
            sb.popIndent();
        } else {
            this.input.toString(sb);
        }
    }

    @Override
    public void unbuild() {
        super.unbuild();
        this.input.unbuild();
        if (this.fan != null) {
            this.fan.unbuild();
        }
    }

    @Override
    public void updateEligibilities() {
    }

    @Override
    public void updateResponsibilities() {
        if (this.responsible && this.fan != null) {
            this.fan.updateResponsibilities();
        }
    }

    @Override
    public void updateWeights() {
    }
}

